/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book;

import java.util.stream.Stream;
import vazkii.patchouli.client.book.EntryDisplayState;

public abstract class AbstractReadStateHolder {
    transient EntryDisplayState readState;
    transient boolean readStateDirty = true;

    public EntryDisplayState getReadState() {
        if (this.readStateDirty) {
            this.readState = this.computeReadState();
            this.readStateDirty = false;
        }
        return this.readState;
    }

    public void markReadStateDirty() {
        this.readStateDirty = true;
    }

    protected abstract EntryDisplayState computeReadState();

    public static EntryDisplayState mostImportantState(Stream<EntryDisplayState> stream) {
        return EntryDisplayState.fromOrdinal(stream.mapToInt(Enum::ordinal).min().orElse(EntryDisplayState.DEFAULT_TYPE.ordinal()));
    }
}

