/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.item;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.common.base.PatchouliSounds;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.item.PatchouliItems;

public class ItemModBook
extends Item {
    public static final String TAG_BOOK = "patchouli:book";

    public ItemModBook() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f));
    }

    public static float getCompletion(ItemStack stack) {
        Book book = ItemModBook.getBook(stack);
        float progression = 0.0f;
        if (book != null) {
            int totalEntries = 0;
            int unlockedEntries = 0;
            for (BookEntry entry : book.contents.entries.values()) {
                if (entry.isSecret()) continue;
                ++totalEntries;
                if (entry.isLocked()) continue;
                ++unlockedEntries;
            }
            progression = (float)unlockedEntries / Math.max(1.0f, (float)totalEntries);
        }
        return progression;
    }

    public static ItemStack forBook(Book book) {
        return ItemModBook.forBook(book.id);
    }

    public static ItemStack forBook(ResourceLocation book) {
        ItemStack stack = new ItemStack((IItemProvider)PatchouliItems.book);
        CompoundNBT cmp = new CompoundNBT();
        cmp.func_74778_a(TAG_BOOK, book.toString());
        stack.func_77982_d(cmp);
        return stack;
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> items) {
        String tabName = (String)ObfuscationReflectionHelper.getPrivateValue(ItemGroup.class, (Object)tab, (String)"field_78034_o");
        BookRegistry.INSTANCE.books.values().forEach(b -> {
            if (!(b.noBook || b.isExtension || tab != ItemGroup.field_78027_g && !b.creativeTab.equals(tabName))) {
                items.add((Object)ItemModBook.forBook(b));
            }
        });
    }

    public static Book getBook(ItemStack stack) {
        ResourceLocation res = ItemModBook.getBookId(stack);
        if (res == null) {
            return null;
        }
        return BookRegistry.INSTANCE.books.get(res);
    }

    private static ResourceLocation getBookId(ItemStack stack) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b(TAG_BOOK)) {
            return null;
        }
        String bookStr = stack.func_77978_p().func_74779_i(TAG_BOOK);
        return ResourceLocation.func_208304_a((String)bookStr);
    }

    public String getCreatorModId(ItemStack itemStack) {
        Book book = ItemModBook.getBook(itemStack);
        if (book != null) {
            return book.owner.getModId();
        }
        return super.getCreatorModId(itemStack);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        Book book = ItemModBook.getBook(stack);
        if (book != null) {
            return new TranslationTextComponent(book.name);
        }
        return super.func_200295_i(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        Book book = ItemModBook.getBook(stack);
        if (book != null && book.contents != null) {
            tooltip.add((ITextComponent)book.getSubtitle().func_240699_a_(TextFormatting.GRAY));
        } else if (book == null) {
            ResourceLocation rl = ItemModBook.getBookId(stack);
            if (rl == null) {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.patchouli.guide_book.undefined").func_240699_a_(TextFormatting.DARK_GRAY));
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.patchouli.guide_book.invalid", new Object[]{rl}).func_240699_a_(TextFormatting.DARK_GRAY));
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        Book book = ItemModBook.getBook(stack);
        if (book == null) {
            return new ActionResult(ActionResultType.FAIL, (Object)stack);
        }
        if (playerIn instanceof ServerPlayerEntity) {
            PatchouliAPI.get().openBookGUI((ServerPlayerEntity)playerIn, book.id);
            SoundEvent sfx = PatchouliSounds.getSound(book.openSound, PatchouliSounds.book_open);
            playerIn.func_184185_a(sfx, 1.0f, (float)(0.7 + Math.random() * 0.4));
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }
}

