/*
 * Decompiled with CFR 0.152.
 */
package us.drullk.parry;

import java.util.function.BiConsumer;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import us.drullk.parry.ParryConfig;
import us.drullk.parry.ParryEnchantment;

@Mod(value="parry")
@Mod.EventBusSubscriber(modid="parry")
public class ShieldParry {
    public static final String MODID = "parry";
    public static final ITag.INamedTag<EntityType<?>> BYPASSES = EntityTypeTags.func_232896_a_((String)"parry:projectiles_parrying_disabled");
    private static Logger LOGGER = LogManager.getLogger((String)"parry");

    public ShieldParry() {
        Pair pairConfigSpec = new ForgeConfigSpec.Builder().configure(ParryConfig::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (ForgeConfigSpec)pairConfigSpec.getRight());
        ParryConfig.INSTANCE = (ParryConfig)pairConfigSpec.getLeft();
    }

    private static <T extends ProjectileEntity> boolean parryProjectile(T projectile, LivingEntity entityBlocking, boolean takeOwnership, BiConsumer<Vector3d, T> trajectoryChange) {
        if (!BYPASSES.func_230235_a_((Object)projectile.func_200600_R()) && entityBlocking.func_184585_cz() && entityBlocking.func_184607_cu().func_77988_m() - entityBlocking.func_184605_cv() <= ShieldParry.applyTimerBonus((Integer)ParryConfig.INSTANCE.shieldParryTicks.get(), entityBlocking.func_184607_cu(), (Double)ParryConfig.INSTANCE.shieldEnchantmentMultiplier.get())) {
            if (takeOwnership) {
                projectile.func_212361_a((Entity)entityBlocking);
                projectile.field_234611_d_ = true;
            }
            trajectoryChange.accept(entityBlocking.func_70040_Z(), (Vector3d)projectile);
            return true;
        }
        return false;
    }

    private static boolean dispatchShieldParry(Entity possibleProjectile, RayTraceResult rayTraceResult, boolean takeOwnership, BiConsumer<Vector3d, ProjectileEntity> trajectoryChange) {
        if (possibleProjectile.field_70170_p.func_201670_d() || !(possibleProjectile instanceof ProjectileEntity) || !(rayTraceResult instanceof EntityRayTraceResult)) {
            return false;
        }
        Entity entity = ((EntityRayTraceResult)rayTraceResult).func_216348_a();
        return entity instanceof LivingEntity && ShieldParry.parryProjectile((ProjectileEntity)possibleProjectile, (LivingEntity)entity, takeOwnership, trajectoryChange);
    }

    private static <T extends ProjectileEntity> boolean dispatchProjectileParry(T projectile, RayTraceResult rayTraceResult, boolean takeOwnership, BiConsumer<Vector3d, T> trajectoryChange) {
        if (projectile.field_70170_p.func_201670_d() || !(rayTraceResult instanceof EntityRayTraceResult)) {
            return false;
        }
        Entity entity = ((EntityRayTraceResult)rayTraceResult).func_216348_a();
        return entity instanceof LivingEntity && ShieldParry.parryProjectile(projectile, (LivingEntity)entity, takeOwnership, trajectoryChange);
    }

    @SubscribeEvent
    public static void parryThisCasual(ProjectileImpactEvent event) {
        if (ShieldParry.dispatchShieldParry(event.getEntity(), event.getRayTraceResult(), !(event.getEntity() instanceof FishingBobberEntity), (reboundAngle, projectile) -> {
            projectile.func_70186_c(reboundAngle.field_72450_a, reboundAngle.field_72448_b, reboundAngle.field_72449_c, 1.1f, 0.1f);
            if (projectile instanceof DamagingProjectileEntity) {
                DamagingProjectileEntity damagingProjectile = (DamagingProjectileEntity)projectile;
                damagingProjectile.field_70232_b = reboundAngle.field_72450_a * 0.1;
                damagingProjectile.field_70233_c = reboundAngle.field_72448_b * 0.1;
                damagingProjectile.field_70230_d = reboundAngle.field_72449_c * 0.1;
            }
        })) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void arrowParry(ProjectileImpactEvent.Arrow event) {
        if (ShieldParry.dispatchProjectileParry(event.getArrow(), event.getRayTraceResult(), true, (reboundAngle, projectile) -> projectile.func_70186_c(reboundAngle.field_72450_a, reboundAngle.field_72448_b, reboundAngle.field_72449_c, 1.1f, 0.1f))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void fireballParry(ProjectileImpactEvent.Fireball event) {
        if (ShieldParry.dispatchProjectileParry(event.getFireball(), event.getRayTraceResult(), true, (reboundAngle, projectile) -> {
            projectile.func_70186_c(reboundAngle.field_72450_a, reboundAngle.field_72448_b, reboundAngle.field_72449_c, 1.1f, 0.1f);
            projectile.field_70232_b = reboundAngle.field_72450_a * 0.1;
            projectile.field_70233_c = reboundAngle.field_72448_b * 0.1;
            projectile.field_70230_d = reboundAngle.field_72449_c * 0.1;
        })) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void throwableParry(ProjectileImpactEvent.Throwable event) {
        if (ShieldParry.dispatchProjectileParry(event.getThrowable(), event.getRayTraceResult(), true, (reboundAngle, projectile) -> projectile.func_70186_c(reboundAngle.field_72450_a, reboundAngle.field_72448_b, reboundAngle.field_72449_c, 1.1f, 0.1f))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void fireworkParry(ProjectileImpactEvent.FireworkRocket event) {
        if (ShieldParry.dispatchProjectileParry(event.getFireworkRocket(), event.getRayTraceResult(), true, (reboundAngle, projectile) -> projectile.func_70186_c(reboundAngle.field_72450_a, reboundAngle.field_72448_b, reboundAngle.field_72449_c, 1.1f, 0.1f))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void fishhookParry(ProjectileImpactEvent.FishingBobber event) {
        if (ShieldParry.dispatchProjectileParry(event.getFishingBobber(), event.getRayTraceResult(), false, (reboundAngle, projectile) -> projectile.func_70186_c(reboundAngle.field_72450_a, reboundAngle.field_72448_b, reboundAngle.field_72449_c, 1.1f, 0.1f))) {
            event.setCanceled(true);
        }
    }

    private static int applyTimerBonus(int base, ItemStack stack, double multiplier) {
        return (int)((double)base + (double)(base * EnchantmentHelper.func_77506_a((Enchantment)ParryEnchantment.reboundEnchantment, (ItemStack)stack)) * multiplier);
    }
}

