/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.common.util;

import hellfirepvp.observerlib.common.util.IOPredicate;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class AlternatingSet<T> {
    private final Object flipLock = new Object();
    private Set<T> actualSet = new HashSet<T>();
    private Set<T> flippedSet = new HashSet<T>();
    private boolean accessible = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T entry) {
        Object object = this.flipLock;
        synchronized (object) {
            if (this.accessible) {
                this.actualSet.add(entry);
            } else {
                this.flippedSet.add(entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(IOPredicate<T> entryConsumer) throws IOException {
        Object object = this.flipLock;
        synchronized (object) {
            this.accessible = false;
            HashSet<T> set = new HashSet<T>();
            for (T t : this.actualSet) {
                if (!entryConsumer.testUnsafe(t)) continue;
                set.add(t);
            }
            this.actualSet = set;
            this.accessible = true;
            this.actualSet.addAll(this.flippedSet);
            this.flippedSet.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.flipLock;
        synchronized (object) {
            this.actualSet.clear();
            this.flippedSet.clear();
        }
    }

    public int size() {
        return this.actualSet.size() + this.flippedSet.size();
    }

    public boolean isEmpty() {
        return this.actualSet.isEmpty() && this.flippedSet.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(T o) {
        Object object = this.flipLock;
        synchronized (object) {
            return this.actualSet.contains(o) || this.flippedSet.contains(o);
        }
    }
}

