/*
 * Decompiled with CFR 0.152.
 */
package uno.time;

import glm_.glm;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import uno.time.Timer$WhenMappings;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0001(B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0003J\u0006\u0010#\u001a\u00020!J\u000e\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020\u0003J\u0006\u0010&\u001a\u00020\u000fJ\u0006\u0010'\u001a\u00020\u000fR\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000bR\u000e\u0010\u0016\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000bR\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006)"}, d2={"Luno/time/Timer;", "", "secDuration", "", "(F)V", "type", "Luno/time/Timer$Type;", "(Luno/time/Timer$Type;F)V", "absPrevTime", "alpha", "getAlpha", "()F", "duration", "getDuration", "hasUpdated", "", "isPaused", "()Z", "setPaused", "(Z)V", "progression", "getProgression", "secAccumTime", "getSecDuration", "start", "", "timeSinceStart", "getTimeSinceStart", "getType", "()Luno/time/Timer$Type;", "setType", "(Luno/time/Timer$Type;)V", "fastForward", "", "secFF", "reset", "rewind", "secRewind", "togglePause", "update", "Type", "core"})
public final class Timer {
    private boolean hasUpdated;
    private boolean isPaused;
    private float absPrevTime;
    private float secAccumTime;
    private final long start;
    @NotNull
    private Type type;
    private final float secDuration;

    public final boolean isPaused() {
        return this.isPaused;
    }

    public final void setPaused(boolean bl) {
        this.isPaused = bl;
    }

    public final void reset() {
        this.hasUpdated = false;
        this.secAccumTime = 0.0f;
    }

    public final boolean togglePause() {
        this.isPaused = !this.isPaused;
        return this.isPaused;
    }

    public final boolean update() {
        float absCurrTime = (float)(System.currentTimeMillis() - this.start) / 1000.0f;
        if (!this.hasUpdated) {
            this.absPrevTime = absCurrTime;
            this.hasUpdated = true;
        }
        if (this.isPaused) {
            this.absPrevTime = absCurrTime;
            return false;
        }
        float deltaTime = absCurrTime - this.absPrevTime;
        this.secAccumTime += deltaTime;
        this.absPrevTime = absCurrTime;
        if (this.type == Type.Single) {
            return this.secAccumTime > this.secDuration;
        }
        return false;
    }

    public final void rewind(float secRewind) {
        this.secAccumTime -= secRewind;
        if (this.secAccumTime < 0.0f) {
            this.secAccumTime = 0.0f;
        }
    }

    public final void fastForward(float secFF) {
        this.secAccumTime += secFF;
    }

    public final float getAlpha() {
        float f2;
        switch (Timer$WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: {
                f2 = glm.INSTANCE.mod(this.secAccumTime, this.secDuration) / this.secDuration;
                break;
            }
            case 2: {
                f2 = glm.INSTANCE.clamp(this.secAccumTime / this.secDuration, 0.0f, 1.0f);
                break;
            }
            default: {
                f2 = -1.0f;
            }
        }
        return f2;
    }

    public final float getProgression() {
        float f2;
        switch (Timer$WhenMappings.$EnumSwitchMapping$1[this.type.ordinal()]) {
            case 1: {
                f2 = glm.INSTANCE.mod(this.secAccumTime, this.secDuration);
                break;
            }
            case 2: {
                f2 = glm.INSTANCE.clamp(this.secAccumTime, 0.0f, this.secDuration);
                break;
            }
            default: {
                f2 = -1.0f;
            }
        }
        return f2;
    }

    public final float getTimeSinceStart() {
        return this.secAccumTime;
    }

    public final float getDuration() {
        return this.secDuration;
    }

    @NotNull
    public final Type getType() {
        return this.type;
    }

    public final void setType(@NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"<set-?>");
        this.type = type;
    }

    public final float getSecDuration() {
        return this.secDuration;
    }

    public Timer(@NotNull Type type, float secDuration) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.type = type;
        this.secDuration = secDuration;
        this.start = System.currentTimeMillis();
        if (this.type != Type.Infinite) {
            boolean bl = this.secDuration > 0.0f;
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        }
    }

    public Timer(float secDuration) {
        this(Type.Infinite, 1.0f);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Luno/time/Timer$Type;", "", "(Ljava/lang/String;I)V", "Loop", "Single", "Infinite", "MAX", "core"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type Loop;
        public static final /* enum */ Type Single;
        public static final /* enum */ Type Infinite;
        public static final /* enum */ Type MAX;
        private static final /* synthetic */ Type[] $VALUES;

        static {
            Type[] typeArray = new Type[4];
            Type[] typeArray2 = typeArray;
            typeArray[0] = Loop = new Type();
            typeArray[1] = Single = new Type();
            typeArray[2] = Infinite = new Type();
            typeArray[3] = MAX = new Type();
            $VALUES = typeArray;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }
    }
}

