/*
 * Decompiled with CFR 0.152.
 */
package glm_.ext;

import glm_.func.Func_trigonometricKt;
import glm_.glm;
import glm_.quat.Quat;
import glm_.quat.QuatD;
import glm_.vec3.Vec3;
import glm_.vec3.Vec3d;
import glm_.vec3.operators.Vec3_operatorsKt;
import glm_.vec3.operators.Vec3d_operatorsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\u0010\u0006\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J\u0010\u0010\u0002\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\r"}, d2={"Lglm_/ext/ext_quaternionExponential;", "", "exp", "Lglm_/quat/Quat;", "q", "Lglm_/quat/QuatD;", "log", "pow", "x", "y", "", "", "sqrt", "glm-jdk8"})
public interface ext_quaternionExponential {
    @NotNull
    public Quat exp(@NotNull Quat var1);

    @NotNull
    public Quat log(@NotNull Quat var1);

    @NotNull
    public Quat pow(@NotNull Quat var1, float var2);

    @NotNull
    public Quat sqrt(@NotNull Quat var1);

    @NotNull
    public QuatD exp(@NotNull QuatD var1);

    @NotNull
    public QuatD log(@NotNull QuatD var1);

    @NotNull
    public QuatD pow(@NotNull QuatD var1, double var2);

    @NotNull
    public QuatD sqrt(@NotNull QuatD var1);

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @NotNull
        public static Quat exp(@NotNull ext_quaternionExponential $this, @NotNull Quat q) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            Vec3 u = new Vec3(q.x.floatValue(), q.y.floatValue(), q.z.floatValue());
            float angle = u.length();
            if (angle < glm.INSTANCE.get\u03b5f()) {
                return new Quat();
            }
            Vec3 v2 = u.div(angle);
            return new Quat(Func_trigonometricKt.getCos(angle), Vec3_operatorsKt.times(Func_trigonometricKt.getSin(angle), v2));
        }

        @NotNull
        public static Quat log(@NotNull ext_quaternionExponential $this, @NotNull Quat q) {
            Quat quat;
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            Vec3 u = new Vec3(q.x.floatValue(), q.y.floatValue(), q.z.floatValue());
            float vec3Len = u.length();
            if (vec3Len < glm.INSTANCE.get\u03b5f()) {
                quat = q.w.floatValue() > 0.0f ? new Quat(glm.INSTANCE.log(q.w.floatValue()), 0.0f, 0.0f, 0.0f) : (q.w.floatValue() < 0.0f ? new Quat(glm.INSTANCE.log(-q.w.floatValue()), glm.INSTANCE.get\u03c0f(), 0.0f, 0.0f) : new Quat(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY));
            } else {
                float t = glm.INSTANCE.atan(vec3Len, q.w.floatValue()) / vec3Len;
                float quatLen2 = vec3Len * vec3Len + q.w.floatValue() * q.w.floatValue();
                quat = new Quat(0.5f * glm.INSTANCE.log(quatLen2), t * q.x.floatValue(), t * q.y.floatValue(), t * q.z.floatValue());
            }
            return quat;
        }

        @NotNull
        public static Quat pow(@NotNull ext_quaternionExponential $this, @NotNull Quat x, float y) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            if (y > -glm.INSTANCE.get\u03b5f() && y < glm.INSTANCE.get\u03b5f()) {
                return new Quat(1.0f, 0.0f, 0.0f, 0.0f);
            }
            float f2 = x.x.floatValue() * x.x.floatValue() + x.y.floatValue() * x.y.floatValue() + x.z.floatValue() * x.z.floatValue() + x.w.floatValue() * x.w.floatValue();
            boolean bl = false;
            float magnitude = (float)Math.sqrt(f2);
            f2 = x.w.floatValue() / magnitude;
            bl = false;
            if (Math.abs(f2) > 1.0f - glm.INSTANCE.get\u03b5f()) {
                f2 = x.w.floatValue() / magnitude;
                bl = false;
                if (Math.abs(f2) < 1.0f + glm.INSTANCE.get\u03b5f()) {
                    return new Quat(glm.INSTANCE.pow(x.w.floatValue(), y), 0.0f, 0.0f, 0.0f);
                }
            }
            float f3 = x.w.floatValue() / magnitude;
            boolean bl2 = false;
            float angle = (float)Math.acos(f3);
            float newAngle = angle * y;
            boolean bl3 = false;
            bl3 = false;
            float div = (float)Math.sin(newAngle) / (float)Math.sin(angle);
            float mag = glm.INSTANCE.pow(magnitude, y - 1.0f);
            boolean bl4 = false;
            return new Quat((float)Math.cos(newAngle) * magnitude * mag, x.x.floatValue() * div * mag, x.y.floatValue() * div * mag, x.z.floatValue() * div * mag);
        }

        @NotNull
        public static Quat sqrt(@NotNull ext_quaternionExponential $this, @NotNull Quat q) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            return $this.pow(q, 0.5f);
        }

        @NotNull
        public static QuatD exp(@NotNull ext_quaternionExponential $this, @NotNull QuatD q) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            Vec3d u = new Vec3d(q.x.doubleValue(), q.y.doubleValue(), q.z.doubleValue());
            double angle = u.length();
            if (angle < glm.INSTANCE.get\u03b5()) {
                return new QuatD();
            }
            Vec3d v2 = u.div(angle);
            return new QuatD(Func_trigonometricKt.getCos(angle), Vec3d_operatorsKt.times(Func_trigonometricKt.getSin(angle), v2));
        }

        @NotNull
        public static QuatD log(@NotNull ext_quaternionExponential $this, @NotNull QuatD q) {
            QuatD quatD;
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            Vec3d u = new Vec3d(q.x.doubleValue(), q.y.doubleValue(), q.z.doubleValue());
            double vec3Len = u.length();
            if (vec3Len < glm.INSTANCE.get\u03b5()) {
                quatD = q.w.doubleValue() > 0.0 ? new QuatD(glm.INSTANCE.log(q.w.doubleValue()), 0.0, 0.0, 0.0) : (q.w.doubleValue() < 0.0 ? new QuatD(glm.INSTANCE.log(-q.w.doubleValue()), glm.INSTANCE.get\u03c0(), 0.0, 0.0) : new QuatD(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY));
            } else {
                double t = glm.INSTANCE.atan(vec3Len, q.w.doubleValue()) / vec3Len;
                double quatLen2 = vec3Len * vec3Len + q.w.doubleValue() * q.w.doubleValue();
                quatD = new QuatD(0.5 * glm.INSTANCE.log(quatLen2), t * q.x.doubleValue(), t * q.y.doubleValue(), t * q.z.doubleValue());
            }
            return quatD;
        }

        @NotNull
        public static QuatD pow(@NotNull ext_quaternionExponential $this, @NotNull QuatD x, double y) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            if (y > -glm.INSTANCE.get\u03b5() && y < glm.INSTANCE.get\u03b5()) {
                return new QuatD(1.0, 0.0, 0.0, 0.0);
            }
            double d = x.x.doubleValue() * x.x.doubleValue() + x.y.doubleValue() * x.y.doubleValue() + x.z.doubleValue() * x.z.doubleValue() + x.w.doubleValue() * x.w.doubleValue();
            boolean bl = false;
            double magnitude = Math.sqrt(d);
            d = x.w.doubleValue() / magnitude;
            bl = false;
            if (Math.abs(d) > (double)1.0f - glm.INSTANCE.get\u03b5()) {
                d = x.w.doubleValue() / magnitude;
                bl = false;
                if (Math.abs(d) < 1.0 + glm.INSTANCE.get\u03b5()) {
                    return new QuatD(glm.INSTANCE.pow(x.w.doubleValue(), y), 0.0, 0.0, 0.0);
                }
            }
            double d2 = x.w.doubleValue() / magnitude;
            boolean bl2 = false;
            double angle = Math.acos(d2);
            double newAngle = angle * y;
            boolean bl3 = false;
            bl3 = false;
            double div = Math.sin(newAngle) / Math.sin(angle);
            double mag = glm.INSTANCE.pow(magnitude, y - 1.0);
            boolean bl4 = false;
            return new QuatD(Math.cos(newAngle) * magnitude * mag, x.x.doubleValue() * div * mag, x.y.doubleValue() * div * mag, x.z.doubleValue() * div * mag);
        }

        @NotNull
        public static QuatD sqrt(@NotNull ext_quaternionExponential $this, @NotNull QuatD q) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            return $this.pow(q, 0.5);
        }
    }
}

