/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pnm;

import com.twelvemonkeys.imageio.plugins.pnm.HeaderParser;
import com.twelvemonkeys.imageio.plugins.pnm.PNMHeader;
import com.twelvemonkeys.imageio.plugins.pnm.TupleType;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

final class PNMHeaderParser
extends HeaderParser {
    private final short fileType;
    private final TupleType tupleType;

    public PNMHeaderParser(ImageInputStream imageInputStream, short s) {
        super(imageInputStream);
        this.fileType = s;
        this.tupleType = PNMHeaderParser.asTupleType(s);
    }

    static TupleType asTupleType(int n) {
        switch (n) {
            case 20529: 
            case 20532: {
                return TupleType.BLACKANDWHITE_WHITE_IS_ZERO;
            }
            case 20530: 
            case 20533: {
                return TupleType.GRAYSCALE;
            }
            case 20531: 
            case 20534: {
                return TupleType.RGB;
            }
        }
        throw new AssertionError((Object)("Illegal PNM type :" + n));
    }

    @Override
    public PNMHeader parse() throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = this.tupleType == TupleType.BLACKANDWHITE_WHITE_IS_ZERO ? 1 : 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (n == 0 || n2 == 0 || n3 == 0) {
            String[] stringArray;
            String string = this.input.readLine();
            if (string == null) {
                throw new IIOException("Unexpeced end of stream");
            }
            int n4 = string.indexOf(35);
            if (n4 >= 0) {
                stringArray = string.substring(n4 + 1).trim();
                if (!stringArray.isEmpty()) {
                    arrayList.add((String)stringArray);
                }
                string = string.substring(0, n4);
            }
            if ((string = string.trim()).isEmpty()) continue;
            for (String string2 : stringArray = string.split("\\s")) {
                if (n == 0) {
                    n = Integer.parseInt(string2);
                    continue;
                }
                if (n2 == 0) {
                    n2 = Integer.parseInt(string2);
                    continue;
                }
                if (n3 == 0) {
                    n3 = Integer.parseInt(string2);
                    continue;
                }
                throw new IIOException("Unknown PNM token: " + string2);
            }
        }
        return new PNMHeader(this.fileType, this.tupleType, n, n2, this.tupleType.getSamplesPerPixel(), n3, arrayList);
    }
}

