/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pcx;

import com.twelvemonkeys.imageio.AbstractMetadata;
import com.twelvemonkeys.imageio.plugins.pcx.PCXHeader;
import java.awt.image.IndexColorModel;
import javax.imageio.metadata.IIOMetadataNode;

final class PCXMetadata
extends AbstractMetadata {
    private final PCXHeader header;
    private final IndexColorModel vgaPalette;

    PCXMetadata(PCXHeader pCXHeader, IndexColorModel indexColorModel) {
        this.header = pCXHeader;
        this.vgaPalette = indexColorModel;
    }

    @Override
    protected IIOMetadataNode getStandardChromaNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Chroma");
        IndexColorModel indexColorModel = null;
        boolean bl = false;
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("ColorSpaceType");
        switch (this.header.getBitsPerPixel()) {
            case 1: 
            case 2: 
            case 4: {
                indexColorModel = this.header.getEGAPalette();
                iIOMetadataNode2.setAttribute("name", "RGB");
                break;
            }
            case 8: {
                if (this.header.getChannels() == 1 && this.vgaPalette != null) {
                    indexColorModel = this.vgaPalette;
                    iIOMetadataNode2.setAttribute("name", "RGB");
                    break;
                }
                if (this.header.getChannels() == 1) {
                    iIOMetadataNode2.setAttribute("name", "GRAY");
                    bl = true;
                    break;
                }
                iIOMetadataNode2.setAttribute("name", "RGB");
                break;
            }
            case 24: {
                iIOMetadataNode2.setAttribute("name", "RGB");
                break;
            }
            default: {
                iIOMetadataNode2.setAttribute("name", "Unknown");
            }
        }
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("NumChannels");
        iIOMetadataNode3.setAttribute("value", bl ? "1" : "3");
        iIOMetadataNode.appendChild(iIOMetadataNode3);
        IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("BlackIsZero");
        iIOMetadataNode4.setAttribute("value", "TRUE");
        iIOMetadataNode.appendChild(iIOMetadataNode4);
        if (indexColorModel != null) {
            IIOMetadataNode iIOMetadataNode5 = new IIOMetadataNode("Palette");
            iIOMetadataNode.appendChild(iIOMetadataNode5);
            for (int j = 0; j < indexColorModel.getMapSize(); ++j) {
                IIOMetadataNode iIOMetadataNode6 = new IIOMetadataNode("PaletteEntry");
                iIOMetadataNode6.setAttribute("index", Integer.toString(j));
                iIOMetadataNode6.setAttribute("red", Integer.toString(indexColorModel.getRed(j)));
                iIOMetadataNode6.setAttribute("green", Integer.toString(indexColorModel.getGreen(j)));
                iIOMetadataNode6.setAttribute("blue", Integer.toString(indexColorModel.getBlue(j)));
                iIOMetadataNode5.appendChild(iIOMetadataNode6);
            }
        }
        return iIOMetadataNode;
    }

    @Override
    protected IIOMetadataNode getStandardCompressionNode() {
        if (this.header.getCompression() != 0) {
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Compression");
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("CompressionTypeName");
            iIOMetadataNode2.setAttribute("value", this.header.getCompression() == 1 ? "RLE" : "Uknown");
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("Lossless");
            iIOMetadataNode3.setAttribute("value", "TRUE");
            iIOMetadataNode.appendChild(iIOMetadataNode3);
            return iIOMetadataNode;
        }
        return null;
    }

    @Override
    protected IIOMetadataNode getStandardDataNode() {
        IIOMetadataNode iIOMetadataNode;
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("Data");
        if (this.header.getChannels() > 1) {
            iIOMetadataNode = new IIOMetadataNode("PlanarConfiguration");
            iIOMetadataNode.setAttribute("value", "LineInterleaved");
            iIOMetadataNode2.appendChild(iIOMetadataNode);
        }
        iIOMetadataNode = new IIOMetadataNode("SampleFormat");
        switch (this.header.getBitsPerPixel()) {
            case 1: 
            case 2: 
            case 4: {
                iIOMetadataNode.setAttribute("value", "Index");
                break;
            }
            case 8: {
                if (this.header.getChannels() == 1 && this.vgaPalette != null) {
                    iIOMetadataNode.setAttribute("value", "Index");
                    break;
                }
            }
            default: {
                iIOMetadataNode.setAttribute("value", "UnsignedIntegral");
            }
        }
        iIOMetadataNode2.appendChild(iIOMetadataNode);
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("BitsPerSample");
        iIOMetadataNode3.setAttribute("value", this.createListValue(this.header.getChannels(), Integer.toString(this.header.getBitsPerPixel())));
        iIOMetadataNode2.appendChild(iIOMetadataNode3);
        IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("SignificantBitsPerSample");
        iIOMetadataNode4.setAttribute("value", this.createListValue(this.header.getChannels(), Integer.toString(this.header.getBitsPerPixel())));
        iIOMetadataNode2.appendChild(iIOMetadataNode4);
        IIOMetadataNode iIOMetadataNode5 = new IIOMetadataNode("SampleMSB");
        iIOMetadataNode5.setAttribute("value", this.createListValue(this.header.getChannels(), "0"));
        return iIOMetadataNode2;
    }

    private String createListValue(int n, String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int j = 0; j < n; ++j) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(stringArray[j % stringArray.length]);
        }
        return stringBuilder.toString();
    }

    @Override
    protected IIOMetadataNode getStandardDimensionNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Dimension");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("ImageOrientation");
        iIOMetadataNode2.setAttribute("value", "Normal");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    @Override
    protected IIOMetadataNode getStandardDocumentNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Document");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("FormatVersion");
        iIOMetadataNode2.setAttribute("value", String.valueOf(this.header.getVersion()));
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    @Override
    protected IIOMetadataNode getStandardTransparencyNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Transparency");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("Alpha");
        iIOMetadataNode2.setAttribute("value", this.header.getChannels() == 1 || this.header.getChannels() == 3 ? "none" : "nonpremultiplied");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }
}

