/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.iff;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

final class MutableIndexColorModel
extends ColorModel {
    static final int MP_REG_IGNORE = -1;
    final int[] rgbs;

    public MutableIndexColorModel(IndexColorModel indexColorModel) {
        super(indexColorModel.getPixelSize(), indexColorModel.getComponentSize(), indexColorModel.getColorSpace(), indexColorModel.hasAlpha(), indexColorModel.isAlphaPremultiplied(), indexColorModel.getTransparency(), indexColorModel.getTransferType());
        this.rgbs = MutableIndexColorModel.getRGBs(indexColorModel);
    }

    private static int[] getRGBs(IndexColorModel indexColorModel) {
        int[] nArray = new int[indexColorModel.getMapSize()];
        indexColorModel.getRGBs(nArray);
        return nArray;
    }

    public void adjustColorMap(PaletteChange[] paletteChangeArray) {
        for (int j = 0; j < paletteChangeArray.length; ++j) {
            int n = paletteChangeArray[j].index;
            if (n >= this.rgbs.length) {
                System.err.printf("warning - palette change register out of range\n", new Object[0]);
                System.err.printf("    change structure %d  index=%d (max %d)\n", j, n, this.getMapSize() - 1);
                System.err.printf("    ignoring it... colors might get messed up from here\n", new Object[0]);
                continue;
            }
            if (n == -1) continue;
            this.updateRGB(n, (paletteChangeArray[j].r & 0xFF) << 16 | (paletteChangeArray[j].g & 0xFF) << 8 | paletteChangeArray[j].b & 0xFF);
        }
    }

    @Override
    public int getRGB(int n) {
        return this.rgbs[n];
    }

    @Override
    public int getRed(int n) {
        return this.rgbs[n] >> 16 & 0xFF;
    }

    @Override
    public int getGreen(int n) {
        return this.rgbs[n] >> 8 & 0xFF;
    }

    @Override
    public int getBlue(int n) {
        return this.rgbs[n] & 0xFF;
    }

    @Override
    public int getAlpha(int n) {
        return this.rgbs[n] >> 24 & 0xFF;
    }

    private void updateRGB(int n, int n2) {
        this.rgbs[n] = n2;
    }

    public int getMapSize() {
        return this.rgbs.length;
    }

    static class PaletteChange {
        public int index;
        public byte r;
        public byte g;
        public byte b;

        PaletteChange() {
        }
    }
}

