/*
 * Decompiled with CFR 0.152.
 */
package observable.mixin;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import observable.Observable;
import observable.Props;
import observable.server.Profiler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ServerWorld.class})
public class ServerLevelMixin {
    @Redirect(method={"tickLiquid"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/material/FluidState;tick(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V"))
    public final void onTickLiquid(FluidState state, World level, BlockPos pos5) {
        if (Props.notProcessing) {
            state.func_206880_a(level, pos5);
        } else {
            if (Props.fluidDepth < 0) {
                Props.fluidDepth = Thread.currentThread().getStackTrace().length - 1;
            }
            Profiler.TimingData data2 = Observable.INSTANCE.getPROFILER().processFluid(state, pos5, level);
            Props.currentTarget.set(data2);
            long start = System.nanoTime();
            state.func_206880_a(level, pos5);
            data2.setTime(System.nanoTime() - start + data2.getTime());
            Props.currentTarget.set(null);
            data2.setTicks(data2.getTicks() + 1);
        }
    }

    @Redirect(method={"tickBlock"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;tick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Ljava/util/Random;)V"))
    public final void onTickBlock(BlockState state, ServerWorld level, BlockPos pos5, Random random2) {
        if (Props.notProcessing) {
            state.func_227033_a_(level, pos5, random2);
        } else {
            if (Props.blockDepth < 0) {
                Props.blockDepth = Thread.currentThread().getStackTrace().length - 1;
            }
            Profiler.TimingData data2 = Observable.INSTANCE.getPROFILER().processBlock(state, pos5, (World)level);
            Props.currentTarget.set(data2);
            long start = System.nanoTime();
            state.func_227033_a_(level, pos5, random2);
            data2.setTime(System.nanoTime() - start + data2.getTime());
            Props.currentTarget.set(null);
            data2.setTicks(data2.getTicks() + 1);
        }
    }
}

