/*
 * Decompiled with CFR 0.152.
 */
package graphics.scenery.spirvcrossj;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Loader {
    static boolean nativesReady = false;

    public static Platform getPlatform() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            return Platform.WINDOWS;
        }
        if (os.contains("linux")) {
            return Platform.LINUX;
        }
        if (os.contains("mac")) {
            return Platform.MACOS;
        }
        return Platform.UNKNOWN;
    }

    public static void cleanTempFiles() {
        try {
            File[] files;
            for (File file : files = new File(System.getProperty("java.io.tmpdir")).listFiles()) {
                File lock;
                if (!file.isDirectory() || !file.getName().contains("spirvcrossj-natives-tmp") || (lock = new File(file, ".lock")).exists()) continue;
                Files.walk(file.toPath(), new FileVisitOption[0]).map(Path::toFile).sorted((f1, f2) -> -f1.compareTo((File)f2)).forEach(File::delete);
            }
        }
        catch (IOException | NullPointerException e) {
            System.err.println("Unable to delete leftover temporary directories: " + e);
            e.printStackTrace();
        }
    }

    public static void loadNatives() throws IOException {
        String[] jars;
        String classifier;
        String libraryName;
        if (nativesReady) {
            return;
        }
        String lp = System.getProperty("java.library.path");
        File tmpDir = Files.createTempDirectory("spirvcrossj-natives-tmp", new FileAttribute[0]).toFile();
        File lock = new File(tmpDir, ".lock");
        lock.createNewFile();
        lock.deleteOnExit();
        Loader.cleanTempFiles();
        switch (Loader.getPlatform()) {
            case WINDOWS: {
                libraryName = "spirvcrossj.dll";
                classifier = "natives-windows";
                break;
            }
            case LINUX: {
                libraryName = "libspirvcrossj.so";
                classifier = "natives-linux";
                break;
            }
            case MACOS: {
                libraryName = "libspirvcrossj.jnilib";
                classifier = "natives-macos";
                break;
            }
            default: {
                System.err.println("spirvcrossj is not supported on this platform.");
                classifier = "none";
                libraryName = "none";
            }
        }
        if (System.getProperty("java.class.path").toLowerCase().contains("imagej-launcher") || System.getProperty("spirvcrossj.useContextClassLoader") != null) {
            Enumeration<URL> res2 = Thread.currentThread().getContextClassLoader().getResources(libraryName);
            if (!res2.hasMoreElements() && Loader.getPlatform() == Platform.MACOS) {
                res2 = Thread.currentThread().getContextClassLoader().getResources("libspirvcrossj.dylib");
            }
            if (!res2.hasMoreElements()) {
                System.err.println("ERROR: Could not find spirvcrossj libraries.");
                return;
            }
            String jar = "";
            while (res2.hasMoreElements()) {
                String p = res2.nextElement().getPath();
                if (!p.contains("-natives-")) continue;
                jar = p;
                break;
            }
            if (jar.length() == 0) {
                System.err.println("ERROR: Could not find spirvcrossj libraries.");
                return;
            }
            int pathOffset = 5;
            if (Loader.getPlatform() == Platform.WINDOWS) {
                pathOffset = 6;
            }
            jar = (jar = jar.substring(jar.indexOf("file:/") + pathOffset)).contains(classifier) ? jar.substring(0, jar.indexOf("!")) : jar.substring(0, jar.indexOf("!") - 4) + "-" + classifier + ".jar";
            jars = jar.split(File.pathSeparator);
        } else {
            jars = System.getProperty("java.class.path").split(File.pathSeparator);
        }
        for (int i2 = 0; i2 < jars.length; ++i2) {
            String s = jars[i2];
            if (!s.contains("spirvcrossj") || !s.contains("natives")) continue;
            try {
                JarFile jar = new JarFile(s);
                Enumeration<JarEntry> enumEntries = jar.entries();
                while (enumEntries.hasMoreElements()) {
                    int len;
                    JarEntry entry = enumEntries.nextElement();
                    String extension = entry.getName().substring(entry.getName().lastIndexOf(46) + 1);
                    if (!extension.startsWith("so") && !extension.startsWith("dll") && !extension.startsWith("dylib") && !extension.startsWith("jnilib")) continue;
                    File f2 = new File(tmpDir.getAbsolutePath() + File.separator + entry.getName());
                    if (entry.isDirectory()) {
                        f2.mkdir();
                        continue;
                    }
                    InputStream ins = jar.getInputStream(entry);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    FileOutputStream fos = new FileOutputStream(f2);
                    byte[] buffer2 = new byte[1024];
                    while ((len = ins.read(buffer2)) > -1) {
                        baos.write(buffer2, 0, len);
                    }
                    baos.flush();
                    fos.write(baos.toByteArray());
                    fos.close();
                    baos.close();
                    ins.close();
                }
                System.setProperty("java.library.path", lp + File.pathSeparator + tmpDir.getCanonicalPath());
                continue;
            }
            catch (IOException e) {
                System.err.println("Failed to extract native libraries: " + e.getMessage());
                e.printStackTrace();
            }
        }
        lp = System.getProperty("java.library.path");
        System.setProperty("java.library.path", lp + File.pathSeparator + new File(".").getCanonicalPath() + File.separator + "target" + File.separator + "classes");
        try {
            Field fieldSysPath = ClassLoader.class.getDeclaredField("sys_paths");
            fieldSysPath.setAccessible(true);
            fieldSysPath.set(null, null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            System.err.println("Failed to set java.library.path: " + e.getMessage());
            e.printStackTrace();
        }
        try {
            System.loadLibrary("spirvcrossj");
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println("Unable to load native library: " + e.getMessage());
            String osname = System.getProperty("os.name");
            String osclass = osname.substring(0, osname.indexOf(32)).toLowerCase();
            System.err.println("Did you include spirvcrossj-natives-" + osclass + " in your dependencies?");
        }
        nativesReady = true;
    }

    static enum Platform {
        UNKNOWN,
        WINDOWS,
        LINUX,
        MACOS;

    }
}

