/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.tga;

import com.twelvemonkeys.imageio.plugins.tga.TGAImageWriter;
import com.twelvemonkeys.imageio.plugins.tga.TGAProviderInfo;
import com.twelvemonkeys.imageio.spi.ImageWriterSpiBase;
import java.awt.color.ColorSpace;
import java.util.Locale;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;

public final class TGAImageWriterSpi
extends ImageWriterSpiBase {
    public TGAImageWriterSpi() {
        super(new TGAProviderInfo());
    }

    @Override
    public boolean canEncodeImage(ImageTypeSpecifier imageTypeSpecifier) {
        switch (imageTypeSpecifier.getBufferedImageType()) {
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: {
                return true;
            }
            case 4: 
            case 8: 
            case 11: 
            case 12: {
                return false;
            }
        }
        ColorSpace colorSpace2 = imageTypeSpecifier.getColorModel().getColorSpace();
        return colorSpace2.getType() == 5 || colorSpace2.getType() == 6;
    }

    @Override
    public ImageWriter createWriterInstance(Object object) {
        return new TGAImageWriter(this);
    }

    @Override
    public String getDescription(Locale locale) {
        return "TrueVision TGA image writer";
    }
}

