/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pnm;

import com.twelvemonkeys.imageio.ImageWriterBase;
import com.twelvemonkeys.imageio.plugins.pnm.HeaderWriter;
import com.twelvemonkeys.imageio.plugins.pnm.PNMImageWriterSpi;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;

public final class PNMImageWriter
extends ImageWriterBase {
    PNMImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    @Override
    public boolean canWriteRasters() {
        return true;
    }

    @Override
    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        HeaderWriter.write(iIOImage, this.getOriginatingProvider(), this.imageOutput);
        this.processImageStarted(0);
        this.writeImageData(iIOImage);
        this.processImageComplete();
    }

    private void writeImageData(IIOImage iIOImage) throws IOException {
        Raster raster = iIOImage.hasRaster() ? iIOImage.getRaster() : iIOImage.getRenderedImage().getTile(0, 0);
        SampleModel sampleModel = raster.getSampleModel();
        DataBuffer dataBuffer = raster.getDataBuffer();
        int n = raster.getWidth();
        int n2 = raster.getHeight();
        int n3 = sampleModel.getTransferType();
        Object object = null;
        for (int j = 0; j < n2; ++j) {
            object = sampleModel.getDataElements(0, j, n, 1, object, dataBuffer);
            if (n3 == 0) {
                this.imageOutput.write((byte[])object);
            } else if (n3 == 1) {
                short[] sArray = (short[])object;
                this.imageOutput.writeShorts(sArray, 0, sArray.length);
            }
            this.processImageProgress((float)j * 100.0f / (float)n2);
            if (!this.abortRequested()) continue;
            this.processWriteAborted();
            break;
        }
    }

    public static void main(String[] stringArray) throws IOException {
        File file = new File(stringArray[0]);
        File file2 = new File(file.getParentFile(), file.getName().replace('.', '_') + ".ppm");
        BufferedImage bufferedImage = ImageIO.read(file);
        if (bufferedImage == null) {
            System.err.println("input Image == null");
            System.exit(-1);
        }
        System.out.println("image: " + bufferedImage);
        ImageWriter imageWriter = new PNMImageWriterSpi().createWriterInstance();
        if (!file2.exists()) {
            imageWriter.setOutput(ImageIO.createImageOutputStream(file2));
            imageWriter.write(bufferedImage);
        } else {
            System.err.println("Output file " + file2 + " already exists.");
            System.exit(-1);
        }
    }
}

