/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pcx;

import com.twelvemonkeys.imageio.plugins.pcx.CGAColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

final class PCXHeader {
    private static final IndexColorModel MONOCHROME = new IndexColorModel(1, 2, new int[]{0, -1}, 0, false, -1, 0);
    private int version;
    private int compression;
    private int bitsPerPixel;
    private int width;
    private int height;
    private int hdpi;
    private int vdpi;
    private byte[] palette;
    private int channels;
    private int bytesPerLine;
    private int paletteInfo;
    private int hScreenSize;
    private int vScreenSize;

    PCXHeader() {
    }

    public int getVersion() {
        return this.version;
    }

    public int getCompression() {
        return this.compression;
    }

    public int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getBytesPerLine() {
        return this.bytesPerLine;
    }

    public IndexColorModel getEGAPalette() {
        if (this.isCGAVideoMode4() || this.isCGAVideoMode5() || this.isCGAVideoMode6()) {
            return CGAColorModel.create(this.palette, this.bitsPerPixel);
        }
        if (this.bitsPerPixel == 1 && this.channels == 1 && (this.version < 4 || this.isDummyPalette())) {
            return MONOCHROME;
        }
        int n = this.channels * this.bitsPerPixel;
        return new IndexColorModel(n, Math.min(16, 1 << n), this.palette, 0, false);
    }

    private boolean isCGAVideoMode4() {
        return this.bitsPerPixel * this.channels == 2 && this.width == 320 && this.hdpi == 320 && this.height == 200 && this.vdpi == 200;
    }

    private boolean isCGAVideoMode5() {
        return this.bitsPerPixel == 1 && this.channels == 1 && this.width == 320 && this.hdpi == 320 && this.height == 200 && this.vdpi == 200;
    }

    private boolean isCGAVideoMode6() {
        return this.bitsPerPixel == 1 && this.channels == 1 && this.width == 640 && this.hdpi == 640 && this.height == 200 && this.vdpi == 200;
    }

    private boolean isDummyPalette() {
        return this.isEmptyPalette() || this.isPhotoshopPalette();
    }

    private boolean isEmptyPalette() {
        for (int j = 0; j < 48; ++j) {
            if (this.palette[j] == 0) continue;
            return false;
        }
        return true;
    }

    private boolean isPhotoshopPalette() {
        for (int j = 0; j < 16; ++j) {
            int n = j * 3;
            if (this.palette[n] == 15 - j && this.palette[n + 1] == 15 - j && this.palette[n + 2] == 15 - j) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "PCXHeader[version=" + this.version + ", compression=" + this.compression + ", bitsPerPixel=" + this.bitsPerPixel + ", width=" + this.width + ", height=" + this.height + ", hdpi=" + this.hdpi + ", vdpi=" + this.vdpi + ", channels=" + this.channels + ", bytesPerLine=" + this.bytesPerLine + ", paletteInfo=" + this.paletteInfo + ", hScreenSize=" + this.hScreenSize + ", vScreenSize=" + this.vScreenSize + ", palette=" + Arrays.toString(this.palette) + ']';
    }

    public static PCXHeader read(ImageInputStream imageInputStream) throws IOException {
        byte by = imageInputStream.readByte();
        if (by != 10) {
            throw new IIOException(String.format("Not a PCX image. Expected PCX magic 0x%02x: 0x%02x", (byte)10, by));
        }
        PCXHeader pCXHeader = new PCXHeader();
        pCXHeader.version = imageInputStream.readUnsignedByte();
        pCXHeader.compression = imageInputStream.readUnsignedByte();
        pCXHeader.bitsPerPixel = imageInputStream.readUnsignedByte();
        int n = imageInputStream.readUnsignedShort();
        int n2 = imageInputStream.readUnsignedShort();
        pCXHeader.width = imageInputStream.readUnsignedShort() - n + 1;
        pCXHeader.height = imageInputStream.readUnsignedShort() - n2 + 1;
        pCXHeader.hdpi = imageInputStream.readUnsignedShort();
        pCXHeader.vdpi = imageInputStream.readUnsignedShort();
        byte[] byArray = new byte[48];
        imageInputStream.readFully(byArray);
        pCXHeader.palette = byArray;
        imageInputStream.readUnsignedByte();
        pCXHeader.channels = imageInputStream.readUnsignedByte();
        pCXHeader.bytesPerLine = imageInputStream.readUnsignedShort();
        pCXHeader.paletteInfo = imageInputStream.readUnsignedShort() & 2;
        pCXHeader.hScreenSize = imageInputStream.readUnsignedShort();
        pCXHeader.vScreenSize = imageInputStream.readUnsignedShort();
        imageInputStream.skipBytes(128L - imageInputStream.getStreamPosition());
        return pCXHeader;
    }
}

