/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.recipes;

import com.google.gson.JsonObject;
import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.NaturesAura;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class EnabledCondition
implements ICondition {
    private static final ResourceLocation NAME = new ResourceLocation("naturesaura", "enabled");
    private ForgeConfigSpec.ConfigValue<Boolean> config;
    private final String name;

    public EnabledCondition(String name) {
        this.name = name;
        try {
            this.config = (ForgeConfigSpec.ConfigValue)ModConfig.class.getField(name).get(ModConfig.instance);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            NaturesAura.LOGGER.error((Object)e);
        }
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test() {
        return this.config != null && (Boolean)this.config.get() != false;
    }

    public static class Serializer
    implements IConditionSerializer<EnabledCondition> {
        public void write(JsonObject json, EnabledCondition value) {
            json.addProperty("config", value.name);
        }

        public EnabledCondition read(JsonObject json) {
            return new EnabledCondition(JSONUtils.func_151200_h((JsonObject)json, (String)"config"));
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

