/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.gen;

import com.mojang.serialization.Codec;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityAuraBloom;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class WorldGenAuraBloom
extends Feature<NoFeatureConfig> {
    private final Block block;
    private final int chance;
    private final boolean nether;

    public WorldGenAuraBloom(Block block, int chance, boolean nether) {
        super(Codec.unit((Object)IFeatureConfig.field_202429_e));
        this.block = block;
        this.chance = chance;
        this.nether = nether;
    }

    public boolean func_241855_a(ISeedReader worldIn, ChunkGenerator gen, Random rand, BlockPos pos, NoFeatureConfig config) {
        if (rand.nextInt(this.chance) != 0) {
            return false;
        }
        int startX = pos.func_177958_n() + rand.nextInt(16);
        int startZ = pos.func_177952_p() + rand.nextInt(16);
        boolean any = false;
        block0: for (int i = MathHelper.func_76136_a((Random)rand, (int)3, (int)8); i > 0; --i) {
            int offX = startX + MathHelper.func_76136_a((Random)rand, (int)-5, (int)5);
            int offZ = startZ + MathHelper.func_76136_a((Random)rand, (int)-5, (int)5);
            if (this.nether) {
                int y = MathHelper.func_76136_a((Random)rand, (int)0, (int)128);
                for (int off = 0; off < 64; ++off) {
                    if (!this.tryPlace(worldIn, new BlockPos(offX, y - off, offZ)) && !this.tryPlace(worldIn, new BlockPos(offX, y + off, offZ))) continue;
                    any = true;
                    continue block0;
                }
                continue;
            }
            BlockPos placePos = new BlockPos(offX, worldIn.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, offX, offZ), offZ);
            if (!this.tryPlace(worldIn, placePos)) continue;
            any = true;
        }
        return any;
    }

    private boolean tryPlace(ISeedReader world, BlockPos pos) {
        BlockState state = this.block.func_176223_P();
        if (this.block.func_196260_a(state, (IWorldReader)world, pos)) {
            world.func_180501_a(pos, state, 3);
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileEntityAuraBloom) {
                ((TileEntityAuraBloom)tile).justGenerated = true;
            }
            return true;
        }
        return false;
    }
}

