/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.events;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.mojang.brigadier.CommandDispatcher;
import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.misc.IWorldData;
import de.ellpeck.naturesaura.chunk.AuraChunk;
import de.ellpeck.naturesaura.chunk.AuraChunkProvider;
import de.ellpeck.naturesaura.commands.CommandAura;
import de.ellpeck.naturesaura.gen.ModFeatures;
import de.ellpeck.naturesaura.misc.WorldData;
import de.ellpeck.naturesaura.packet.PacketHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;

public class CommonEvents {
    private static final Method GET_LOADED_CHUNKS_METHOD = ObfuscationReflectionHelper.findMethod(ChunkManager.class, (String)"func_223491_f", (Class[])new Class[0]);
    private static final ListMultimap<UUID, ChunkPos> PENDING_AURA_CHUNKS = ArrayListMultimap.create();

    @SubscribeEvent
    public void onBiomeLoad(BiomeLoadingEvent event) {
        if (((Boolean)ModConfig.instance.auraBlooms.get()).booleanValue()) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModFeatures.Configured.AURA_BLOOM);
            switch (event.getCategory()) {
                case DESERT: {
                    event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModFeatures.Configured.AURA_CACTUS);
                    break;
                }
                case NETHER: {
                    event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModFeatures.Configured.CRIMSON_AURA_MUSHROOM);
                    event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModFeatures.Configured.WARPED_AURA_MUSHROOM);
                    break;
                }
                case MUSHROOM: {
                    event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModFeatures.Configured.AURA_MUSHROOM);
                }
            }
        }
    }

    @SubscribeEvent
    public void onChunkCapsAttach(AttachCapabilitiesEvent<Chunk> event) {
        Chunk chunk = (Chunk)event.getObject();
        event.addCapability(new ResourceLocation("naturesaura", "aura"), (ICapabilityProvider)new AuraChunkProvider(chunk));
    }

    @SubscribeEvent
    public void onWorldCapsAttach(AttachCapabilitiesEvent<World> event) {
        event.addCapability(new ResourceLocation("naturesaura", "data"), (ICapabilityProvider)new WorldData());
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload event) {
        Chunk chunk;
        IAuraChunk auraChunk;
        IChunk iChunk = event.getChunk();
        if (iChunk instanceof Chunk && (auraChunk = (IAuraChunk)(chunk = (Chunk)iChunk).getCapability(NaturesAuraAPI.capAuraChunk).orElse(null)) instanceof AuraChunk) {
            WorldData data = (WorldData)IWorldData.getWorldData(chunk.func_177412_p());
            data.auraChunksWithSpots.remove(chunk.func_76632_l().func_201841_a());
        }
    }

    @SubscribeEvent
    public void onItemUse(PlayerInteractEvent.RightClickBlock event) {
        BlockState state;
        PlayerEntity player = event.getPlayer();
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        ItemStack held = event.getItemStack();
        if (!held.func_190926_b() && held.func_77973_b().getRegistryName().func_110623_a().contains("chisel") && NaturesAuraAPI.BOTANIST_PICKAXE_CONVERSIONS.containsKey((Object)(state = player.field_70170_p.func_180495_p(event.getPos())))) {
            WorldData data = (WorldData)IWorldData.getWorldData(player.field_70170_p);
            data.addMossStone(event.getPos());
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (!event.world.field_72995_K && event.phase == TickEvent.Phase.END && event.world.func_82737_E() % 20L == 0L) {
            event.world.func_217381_Z().func_76320_a("naturesaura:onWorldTick");
            try {
                ChunkManager manager = ((ServerChunkProvider)event.world.func_72863_F()).field_217237_a;
                Iterable chunks = (Iterable)GET_LOADED_CHUNKS_METHOD.invoke((Object)manager, new Object[0]);
                for (ChunkHolder holder : chunks) {
                    AuraChunk auraChunk;
                    Chunk chunk = holder.func_219298_c();
                    if (chunk == null || (auraChunk = (AuraChunk)chunk.getCapability(NaturesAuraAPI.capAuraChunk, null).orElse(null)) == null) continue;
                    auraChunk.update();
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                NaturesAura.LOGGER.fatal((Object)e);
            }
            event.world.func_217381_Z().func_76319_b();
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.phase == TickEvent.Phase.END) {
            if (event.player.field_70170_p.func_82737_E() % 10L == 0L) {
                List pending = PENDING_AURA_CHUNKS.get((Object)event.player.func_110124_au());
                pending.removeIf(p -> this.handleChunkWatchDeferred(event.player, (ChunkPos)p));
            }
            if (event.player.field_70170_p.func_82737_E() % 200L != 0L) {
                return;
            }
            int aura = IAuraChunk.triangulateAuraInArea((IWorld)event.player.field_70170_p, event.player.func_233580_cy_(), 25);
            if (aura <= 0) {
                Helper.addAdvancement(event.player, new ResourceLocation("naturesaura", "negative_imbalance"), "triggered_in_code");
            } else if (aura >= 1500000) {
                Helper.addAdvancement(event.player, new ResourceLocation("naturesaura", "positive_imbalance"), "triggered_in_code");
            }
        }
    }

    @SubscribeEvent
    public void onChunkWatch(ChunkWatchEvent.Watch event) {
        PENDING_AURA_CHUNKS.put((Object)event.getPlayer().func_110124_au(), (Object)event.getPos());
    }

    private boolean handleChunkWatchDeferred(PlayerEntity player, ChunkPos pos) {
        Chunk chunk = Helper.getLoadedChunk((IWorld)player.field_70170_p, pos.field_77276_a, pos.field_77275_b);
        if (chunk == null) {
            return false;
        }
        AuraChunk auraChunk = (AuraChunk)chunk.getCapability(NaturesAuraAPI.capAuraChunk, null).orElse(null);
        if (auraChunk == null) {
            return false;
        }
        PacketHandler.sendTo(player, auraChunk.makePacket());
        return true;
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        CommandAura.register((CommandDispatcher<CommandSource>)event.getServer().func_195571_aL().func_197054_a());
    }
}

