/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.entities;

import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityMoverMinecart
extends AbstractMinecartEntity {
    private final List<BlockPos> spotOffsets = new ArrayList<BlockPos>();
    public boolean isActive;
    private BlockPos lastPosition = BlockPos.field_177992_a;

    public EntityMoverMinecart(EntityType<?> type, World world) {
        super(type, world);
    }

    public EntityMoverMinecart(EntityType<?> type, World world, double x, double y, double z) {
        super(type, world, x, y, z);
    }

    public void moveMinecartOnRail(BlockPos railPos) {
        super.moveMinecartOnRail(railPos);
        if (!this.isActive) {
            return;
        }
        BlockPos pos = this.func_233580_cy_();
        if (!this.spotOffsets.isEmpty() && this.field_70170_p.func_82737_E() % 10L == 0L) {
            PacketHandler.sendToAllAround(this.field_70170_p, pos, 32, new PacketParticles((float)this.func_226277_ct_(), (float)this.func_226278_cu_(), (float)this.func_226281_cx_(), PacketParticles.Type.MOVER_CART, MathHelper.func_76128_c((double)(this.func_213322_ci().func_82615_a() * 100.0)), MathHelper.func_76128_c((double)(this.func_213322_ci().func_82617_b() * 100.0)), MathHelper.func_76128_c((double)(this.func_213322_ci().func_82616_c() * 100.0))));
        }
        if (pos.func_177951_i((Vector3i)this.lastPosition) < 64.0) {
            return;
        }
        this.moveAura(this.field_70170_p, this.lastPosition, this.field_70170_p, pos);
        this.lastPosition = pos;
    }

    private void moveAura(World oldWorld, BlockPos oldPos, World newWorld, BlockPos newPos) {
        for (BlockPos offset : this.spotOffsets) {
            int toMove;
            int drained;
            BlockPos spot = oldPos.func_177971_a((Vector3i)offset);
            IAuraChunk chunk = IAuraChunk.getAuraChunk((IWorld)oldWorld, spot);
            int amount = chunk.getDrainSpot(spot);
            if (amount <= 0 || (drained = chunk.drainAura(spot, toMove = Math.min(amount, 300000), false, false)) <= 0) continue;
            int toLose = MathHelper.func_76123_f((float)((float)drained / 250.0f));
            BlockPos newSpot = newPos.func_177971_a((Vector3i)offset);
            IAuraChunk.getAuraChunk((IWorld)newWorld, newSpot).storeAura(newSpot, drained - toLose, false, false);
        }
    }

    public void func_96095_a(int x, int y, int z, boolean receivingPower) {
        if (this.isActive != receivingPower) {
            this.isActive = receivingPower;
            BlockPos pos = this.func_233580_cy_();
            if (!this.isActive) {
                this.moveAura(this.field_70170_p, this.lastPosition, this.field_70170_p, pos);
                this.spotOffsets.clear();
                this.lastPosition = BlockPos.field_177992_a;
                return;
            }
            IAuraChunk.getSpotsInArea((IWorld)this.field_70170_p, pos, 25, (spot, amount) -> {
                if (amount > 0) {
                    this.spotOffsets.add(spot.func_177973_b((Vector3i)pos));
                }
            });
            this.lastPosition = pos;
        }
    }

    public void func_94095_a(DamageSource source) {
        this.func_70106_y();
        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            this.func_70099_a(new ItemStack((IItemProvider)ModItems.MOVER_CART), 0.0f);
        }
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        compound.func_74757_a("active", this.isActive);
        compound.func_74772_a("last_pos", this.lastPosition.func_218275_a());
        ListNBT list = new ListNBT();
        for (BlockPos offset : this.spotOffsets) {
            list.add((Object)LongNBT.func_229698_a_((long)offset.func_218275_a()));
        }
        compound.func_218657_a("offsets", (INBT)list);
        return compound;
    }

    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        this.isActive = compound.func_74767_n("active");
        this.lastPosition = BlockPos.func_218283_e((long)compound.func_74763_f("last_pos"));
        this.spotOffsets.clear();
        ListNBT list = compound.func_150295_c("offsets", 4);
        for (INBT base : list) {
            this.spotOffsets.add(BlockPos.func_218283_e((long)((LongNBT)base).func_150291_c()));
        }
    }

    @Nullable
    public Entity changeDimension(ServerWorld destination, ITeleporter teleporter) {
        Entity entity = super.changeDimension(destination, teleporter);
        if (entity instanceof EntityMoverMinecart) {
            BlockPos pos = entity.func_233580_cy_();
            this.moveAura(this.field_70170_p, this.lastPosition, entity.field_70170_p, pos);
            ((EntityMoverMinecart)entity).lastPosition = pos;
        }
        return entity;
    }

    public BlockState func_174897_t() {
        return Blocks.field_150348_b.func_176223_P();
    }

    public AbstractMinecartEntity.Type func_184264_v() {
        return AbstractMinecartEntity.Type.RIDEABLE;
    }

    public ItemStack getCartItem() {
        return new ItemStack((IItemProvider)ModItems.MOVER_CART);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)ModItems.MOVER_CART);
    }

    public boolean canBeRidden() {
        return false;
    }

    protected void func_94101_h() {
        Vector3d motion = this.func_213322_ci();
        this.func_213293_j(motion.field_72450_a * (double)0.99f, 0.0, motion.field_72449_c * (double)0.99f);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

