/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.compat;

import com.google.common.collect.ImmutableMap;
import de.ellpeck.naturesaura.compat.ICompat;
import de.ellpeck.naturesaura.data.ItemTagProvider;
import de.ellpeck.naturesaura.items.ModItems;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CuriosCompat
implements ICompat {
    private static final Map<Item, String> TYPES = ImmutableMap.builder().put((Object)ModItems.EYE, (Object)"charm").put((Object)ModItems.EYE_IMPROVED, (Object)"charm").put((Object)ModItems.AURA_CACHE, (Object)"belt").put((Object)ModItems.AURA_TROVE, (Object)"belt").put((Object)ModItems.SHOCKWAVE_CREATOR, (Object)"necklace").put((Object)ModItems.DEATH_RING, (Object)"ring").build();

    @Override
    public void setup(FMLCommonSetupEvent event) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::sendImc);
        MinecraftForge.EVENT_BUS.addGenericListener(ItemStack.class, this::onCapabilitiesAttach);
    }

    @Override
    public void setupClient() {
    }

    private void sendImc(InterModEnqueueEvent event) {
        TYPES.values().stream().distinct().forEach(t -> InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder(t).build()));
    }

    private void onCapabilitiesAttach(AttachCapabilitiesEvent<ItemStack> event) {
        final ItemStack stack = (ItemStack)event.getObject();
        if (TYPES.containsKey(stack.func_77973_b())) {
            event.addCapability(new ResourceLocation("naturesaura", "curios"), new ICapabilityProvider(){
                private final LazyOptional<ICurio> curio = LazyOptional.of(() -> new ICurio(){

                    public void curioTick(String identifier, int index, LivingEntity livingEntity) {
                        stack.func_77973_b().func_77663_a(stack, livingEntity.field_70170_p, (Entity)livingEntity, -1, false);
                    }

                    public boolean canEquipFromUse(SlotContext slotContext) {
                        return true;
                    }

                    public boolean canSync(String identifier, int index, LivingEntity livingEntity) {
                        return true;
                    }
                });

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    if (cap != CuriosCapability.ITEM) {
                        return LazyOptional.empty();
                    }
                    return this.curio.cast();
                }
            });
        }
    }

    @Override
    public void addItemTags(ItemTagProvider provider) {
        for (Map.Entry<Item, String> entry : TYPES.entrySet()) {
            Tags.IOptionalNamedTag tag = ItemTags.createOptional((ResourceLocation)new ResourceLocation("curios", entry.getValue()));
            provider.func_240522_a_((ITag.INamedTag<Item>)tag).func_240534_a_((Object[])new Item[]{entry.getKey()});
        }
    }
}

