/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.compat;

import com.google.common.collect.ImmutableMap;
import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.compat.CuriosCompat;
import de.ellpeck.naturesaura.compat.ICompat;
import de.ellpeck.naturesaura.compat.enchantibility.EnchantibilityCompat;
import de.ellpeck.naturesaura.compat.patchouli.PatchouliCompat;
import de.ellpeck.naturesaura.data.ItemTagProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public final class Compat {
    private static final Map<String, Supplier<ICompat>> MODULE_TYPES = ImmutableMap.builder().put((Object)"patchouli", PatchouliCompat::new).put((Object)"curios", CuriosCompat::new).put((Object)"enchantability", EnchantibilityCompat::new).build();
    private static final Map<String, ICompat> MODULES = new HashMap<String, ICompat>();

    public static void setup(FMLCommonSetupEvent event) {
        Compat.populateModules(arg_0 -> ((ModList)ModList.get()).isLoaded(arg_0));
        MODULES.values().forEach(c -> c.setup(event));
    }

    public static void setupClient() {
        MODULES.values().forEach(ICompat::setupClient);
    }

    public static boolean hasCompat(String mod) {
        return MODULES.containsKey(mod);
    }

    public static void addItemTags(ItemTagProvider provider) {
        Compat.populateModules(s -> true);
        MODULES.values().forEach(m -> m.addItemTags(provider));
    }

    private static void populateModules(Predicate<String> isLoaded) {
        for (Map.Entry<String, Supplier<ICompat>> entry : MODULE_TYPES.entrySet()) {
            String id = entry.getKey();
            if (!isLoaded.test(id)) continue;
            MODULES.put(id, entry.getValue().get());
            NaturesAura.LOGGER.info("Loading compat module for mod " + id);
        }
    }
}

