/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.blocks.tiles.ModTileEntities;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityImpl;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CauldronBlock;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.Property;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.ticket.AABBTicket;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntitySpring
extends TileEntityImpl
implements ITickableTileEntity {
    private final LazyOptional<IFluidHandler> tank = LazyOptional.of(() -> new InfiniteTank());
    private AABBTicket waterTicket;

    public TileEntitySpring() {
        super(ModTileEntities.SPRING);
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K) {
            AxisAlignedBB area = new AxisAlignedBB(this.field_174879_c).func_72314_b(5.0, 1.0, 5.0);
            this.waterTicket = FarmlandWaterManager.addAABBTicket((World)this.field_145850_b, (AxisAlignedBB)area);
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K && this.waterTicket != null && this.waterTicket.isValid()) {
            this.waterTicket.invalidate();
            this.waterTicket = null;
        }
        this.tank.invalidate();
    }

    public void func_73660_a() {
        int level;
        if (this.field_145850_b.field_72995_K || this.field_145850_b.func_82737_E() % 35L != 0L) {
            return;
        }
        BlockPos up = this.field_174879_c.func_177984_a();
        BlockState upState = this.field_145850_b.func_180495_p(up);
        if (upState.func_235901_b_((Property)CauldronBlock.field_176591_a) && (level = ((Integer)upState.func_177229_b((Property)CauldronBlock.field_176591_a)).intValue()) < 3) {
            this.field_145850_b.func_175656_a(up, (BlockState)upState.func_206870_a((Property)CauldronBlock.field_176591_a, (Comparable)Integer.valueOf(level + 1)));
            this.field_145850_b.func_184133_a(null, up, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
            this.consumeAura(2500);
            return;
        }
        int spongeRadius = 2;
        for (int x = -spongeRadius; x <= spongeRadius; ++x) {
            for (int y = -spongeRadius; y <= spongeRadius; ++y) {
                for (int z = -spongeRadius; z <= spongeRadius; ++z) {
                    BlockPos pos = this.field_174879_c.func_177982_a(x, y, z);
                    BlockState state = this.field_145850_b.func_180495_p(pos);
                    if (state.func_177230_c() != Blocks.field_150360_v) continue;
                    this.field_145850_b.func_180501_a(pos, Blocks.field_196577_ad.func_176223_P(), 2);
                    this.field_145850_b.func_217379_c(2001, pos, Block.func_196246_j((BlockState)Blocks.field_150355_j.func_176223_P()));
                    this.consumeAura(2500);
                    return;
                }
            }
        }
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos side = this.field_174879_c.func_177972_a(dir);
            if (!this.isLava(side, true)) continue;
            this.field_145850_b.func_175656_a(side, ForgeEventFactory.fireFluidPlaceBlockEvent((IWorld)this.field_145850_b, (BlockPos)side, (BlockPos)side, (BlockState)Blocks.field_150343_Z.func_176223_P()));
            this.field_145850_b.func_217379_c(1501, side, 0);
            this.consumeAura(1500);
            return;
        }
        BlockPos twoUp = this.field_174879_c.func_177981_b(2);
        if (this.isLava(twoUp, false) && (this.field_145850_b.func_180495_p(up).isAir((IBlockReader)this.field_145850_b, up) || this.isLava(up, false))) {
            this.field_145850_b.func_175656_a(up, ForgeEventFactory.fireFluidPlaceBlockEvent((IWorld)this.field_145850_b, (BlockPos)up, (BlockPos)twoUp, (BlockState)Blocks.field_150348_b.func_176223_P()));
            this.field_145850_b.func_217379_c(1501, up, 0);
            this.consumeAura(150);
            return;
        }
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos twoSide = this.field_174879_c.func_177967_a(dir, 2);
            BlockPos side = this.field_174879_c.func_177972_a(dir);
            if (!this.isLava(twoSide, false) || !this.field_145850_b.func_180495_p(side).isAir((IBlockReader)this.field_145850_b, side) && !this.isLava(side, false)) continue;
            this.field_145850_b.func_175656_a(side, ForgeEventFactory.fireFluidPlaceBlockEvent((IWorld)this.field_145850_b, (BlockPos)side, (BlockPos)twoSide, (BlockState)Blocks.field_150347_e.func_176223_P()));
            this.field_145850_b.func_217379_c(1501, side, 0);
            this.consumeAura(100);
            return;
        }
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.tank.cast();
        }
        return LazyOptional.empty();
    }

    public void consumeAura(int amount) {
        while (amount > 0) {
            BlockPos pos = IAuraChunk.getHighestSpot((IWorld)this.field_145850_b, this.field_174879_c, 35, this.field_174879_c);
            amount -= IAuraChunk.getAuraChunk((IWorld)this.field_145850_b, pos).drainAura(pos, amount);
        }
    }

    private boolean isLava(BlockPos offset, boolean source) {
        FluidState state = this.field_145850_b.func_204610_c(offset);
        return (!source || state.func_206889_d()) && state.func_206886_c().func_207185_a((ITag)FluidTags.field_206960_b);
    }

    private class InfiniteTank
    implements IFluidTank,
    IFluidHandler {
        private InfiniteTank() {
        }

        public FluidStack getFluid() {
            return new FluidStack((Fluid)Fluids.field_204546_a, 1000);
        }

        public int getFluidAmount() {
            return 1000;
        }

        public int getCapacity() {
            return 1000;
        }

        public boolean isFluidValid(FluidStack stack) {
            return stack.getFluid().func_207185_a((ITag)FluidTags.field_206959_a);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            int drain = Math.min(maxDrain, 1000);
            if (action.execute()) {
                TileEntitySpring.this.consumeAura(MathHelper.func_76123_f((float)((float)drain / 2.0f)));
            }
            return new FluidStack((Fluid)Fluids.field_204546_a, drain);
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (this.isFluidValid(resource)) {
                return this.drain(resource.getAmount(), action);
            }
            return FluidStack.EMPTY;
        }

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int tank) {
            return this.getFluid();
        }

        public int getTankCapacity(int tank) {
            return this.getCapacity();
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return this.isFluidValid(stack);
        }
    }
}

