/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.tiles.ModTileEntities;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityNatureAltar;
import de.ellpeck.naturesaura.blocks.tiles.render.RenderNatureAltar;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import de.ellpeck.naturesaura.reg.ITESRProvider;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class BlockNatureAltar
extends BlockContainerImpl
implements ITESRProvider<TileEntityNatureAltar>,
ICustomBlockState {
    private static final VoxelShape SHAPE = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.75, (double)1.0);
    public static final BooleanProperty NETHER = BooleanProperty.func_177716_a((String)"nether");

    public BlockNatureAltar() {
        super("nature_altar", TileEntityNatureAltar::new, AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(4.0f).harvestLevel(1).harvestTool(ToolType.PICKAXE));
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)NETHER, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected boolean hasWaterlogging() {
        return true;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        return Helper.putStackOnTile(player, handIn, pos, 0, true);
    }

    @Override
    public Tuple<TileEntityType<TileEntityNatureAltar>, Supplier<Function<? super TileEntityRendererDispatcher, ? extends TileEntityRenderer<? super TileEntityNatureAltar>>>> getTESR() {
        return new Tuple(ModTileEntities.NATURE_ALTAR, () -> RenderNatureAltar::new);
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{NETHER});
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        boolean nether = IAuraType.forWorld((IWorld)context.func_195991_k()).isSimilar(NaturesAuraAPI.TYPE_NETHER);
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)NETHER, (Comparable)Boolean.valueOf(nether));
    }
}

