/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.entities.EntityEffectInhibitor;
import de.ellpeck.naturesaura.items.ItemImpl;
import de.ellpeck.naturesaura.reg.IColorProvidingItem;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemEffectPowder
extends ItemImpl
implements IColorProvidingItem {
    public ItemEffectPowder() {
        super("effect_powder");
    }

    public static ResourceLocation getEffect(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        String effect = stack.func_77978_p().func_74779_i("effect");
        if (effect.isEmpty()) {
            return null;
        }
        return new ResourceLocation(effect);
    }

    public static ItemStack setEffect(ItemStack stack, ResourceLocation effect) {
        stack.func_196082_o().func_74778_a("effect", effect != null ? effect.toString() : "");
        return stack;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        if (!world.field_72995_K) {
            Vector3d hit = context.func_221532_j();
            ItemStack stack = context.func_195999_j().func_184586_b(context.func_221531_n());
            EntityEffectInhibitor.place(world, stack, hit.field_72450_a, hit.field_72448_b + 1.0, hit.field_72449_c);
            stack.func_190920_e(0);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (ResourceLocation effect : NaturesAuraAPI.EFFECT_POWDERS.keySet()) {
                ItemStack stack = new ItemStack((IItemProvider)this);
                ItemEffectPowder.setEffect(stack, effect);
                items.add((Object)stack);
            }
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return new TranslationTextComponent(this.func_77667_c(stack) + "." + ItemEffectPowder.getEffect(stack));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IItemColor getItemColor() {
        return (stack, tintIndex) -> NaturesAuraAPI.EFFECT_POWDERS.getOrDefault(ItemEffectPowder.getEffect(stack), 0xFFFFFF);
    }
}

