/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.compat.patchouli;

import de.ellpeck.naturesaura.compat.patchouli.PatchouliCompat;
import de.ellpeck.naturesaura.recipes.AnimalSpawnerRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.IItemProvider;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class ProcessorAnimalSpawner
implements IComponentProcessor {
    private AnimalSpawnerRecipe recipe;

    public void setup(IVariableProvider provider) {
        this.recipe = (AnimalSpawnerRecipe)PatchouliCompat.getRecipe("animal_spawner", provider.get("recipe").asString());
    }

    public IVariable process(String key) {
        if (this.recipe == null) {
            return null;
        }
        if (key.startsWith("input")) {
            int id = Integer.parseInt(key.substring(5)) - 1;
            if (this.recipe.ingredients.length > id) {
                return PatchouliCompat.ingredientVariable(this.recipe.ingredients[id]);
            }
            return null;
        }
        switch (key) {
            case "name": {
                return IVariable.wrap((String)this.recipe.entity.func_212546_e().getString());
            }
            case "entity": {
                return IVariable.wrap((String)this.recipe.entity.getRegistryName().toString());
            }
            case "egg": {
                ItemStack egg = new ItemStack((IItemProvider)SpawnEggItem.func_200889_b(this.recipe.entity));
                return IVariable.from((Object)egg);
            }
        }
        return null;
    }

    public boolean allowRender(String group) {
        return !"seekrit".equals(group);
    }
}

