/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.container.BasicAuraContainer;
import de.ellpeck.naturesaura.api.aura.container.IAuraContainer;
import de.ellpeck.naturesaura.blocks.tiles.ModTileEntities;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityImpl;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;

public class TileEntityEndFlower
extends TileEntityImpl
implements ITickableTileEntity {
    private final BasicAuraContainer container = new BasicAuraContainer(null, 500000){
        {
            this.aura = this.maxAura;
        }

        @Override
        public int storeAura(int amountToStore, boolean simulate) {
            return 0;
        }

        @Override
        public int drainAura(int amountToDrain, boolean simulate) {
            int amount = super.drainAura(amountToDrain, simulate);
            if (amount > 0 && !simulate) {
                TileEntityEndFlower.this.sendToClients();
            }
            return amount;
        }

        @Override
        public int getAuraColor() {
            return 6956509;
        }
    };
    public boolean isDrainMode;

    public TileEntityEndFlower() {
        super(ModTileEntities.END_FLOWER);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 10L != 0L) {
                return;
            }
            if (!this.isDrainMode) {
                List items = this.field_145850_b.func_175647_a(ItemEntity.class, new AxisAlignedBB(this.field_174879_c).func_186662_g(1.0), EntityPredicates.field_94557_a);
                for (ItemEntity item : items) {
                    ItemStack stack;
                    if (item.func_174874_s() || (stack = item.func_92059_d()).func_190916_E() != 1 || stack.func_77973_b() != Items.field_151061_bv) continue;
                    this.isDrainMode = true;
                    item.func_70106_y();
                    PacketHandler.sendToAllAround(this.field_145850_b, this.field_174879_c, 32, new PacketParticles((float)item.func_226277_ct_(), (float)item.func_226278_cu_(), (float)item.func_226281_cx_(), PacketParticles.Type.END_FLOWER_CONSUME, this.container.getAuraColor()));
                    break;
                }
            } else {
                int toDrain = Math.min(5000, this.container.getStoredAura());
                this.container.drainAura(toDrain, false);
                this.generateAura(toDrain);
                if (this.container.getStoredAura() <= 0) {
                    this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_196555_aI.func_176223_P());
                    PacketHandler.sendToAllAround(this.field_145850_b, this.field_174879_c, 32, new PacketParticles(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), PacketParticles.Type.END_FLOWER_DECAY, this.container.getAuraColor()));
                }
            }
        } else if (this.isDrainMode && this.field_145850_b.func_82737_E() % 5L == 0L) {
            NaturesAuraAPI.instance().spawnMagicParticle((float)this.field_174879_c.func_177958_n() + 0.25f + this.field_145850_b.field_73012_v.nextFloat() * 0.5f, (float)this.field_174879_c.func_177956_o() + 0.25f + this.field_145850_b.field_73012_v.nextFloat() * 0.5f, (float)this.field_174879_c.func_177952_p() + 0.25f + this.field_145850_b.field_73012_v.nextFloat() * 0.5f, this.field_145850_b.field_73012_v.nextGaussian() * (double)0.05f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f, this.field_145850_b.field_73012_v.nextGaussian() * (double)0.05f, this.container.getAuraColor(), this.field_145850_b.field_73012_v.nextFloat() * 2.0f + 1.0f, 50, 0.0f, false, true);
        }
    }

    @Override
    public IAuraContainer getAuraContainer() {
        return this.container;
    }

    @Override
    public void writeNBT(CompoundNBT compound, TileEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type != TileEntityImpl.SaveType.BLOCK) {
            this.container.writeNBT(compound);
            compound.func_74757_a("drain_mode", this.isDrainMode);
        }
    }

    @Override
    public void readNBT(CompoundNBT compound, TileEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type != TileEntityImpl.SaveType.BLOCK) {
            this.container.readNBT(compound);
            this.isDrainMode = compound.func_74767_n("drain_mode");
        }
    }
}

