/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalcustomization.modify;

import com.blakebr0.mysticalagriculture.api.MysticalAgricultureAPI;
import com.blakebr0.mysticalagriculture.api.crop.CropTier;
import com.blakebr0.mysticalagriculture.api.crop.CropType;
import com.blakebr0.mysticalagriculture.api.crop.ICrop;
import com.blakebr0.mysticalagriculture.api.lib.LazyIngredient;
import com.blakebr0.mysticalcustomization.loader.CropLoader;
import com.blakebr0.mysticalcustomization.util.ParsingUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public final class CropModifier {
    public static void modify(ICrop crop, JsonObject json) throws JsonSyntaxException {
        if (json.has("name")) {
            String name = JSONUtils.func_151200_h((JsonObject)json, (String)"name");
            crop.setDisplayName((ITextComponent)new StringTextComponent(name));
        }
        if (json.has("tier")) {
            String tierId = JSONUtils.func_151200_h((JsonObject)json, (String)"tier");
            CropTier tier = MysticalAgricultureAPI.getCropTierById((ResourceLocation)new ResourceLocation(tierId));
            if (tier == null) {
                throw new JsonSyntaxException("Invalid crop tier provided: " + tierId);
            }
            crop.setTier(tier);
        }
        if (json.has("type")) {
            String typeId = JSONUtils.func_151200_h((JsonObject)json, (String)"type");
            CropType type = MysticalAgricultureAPI.getCropTypeByName((String)typeId);
            if (type == null) {
                throw new JsonSyntaxException("Invalid crop type provided: " + typeId);
            }
            crop.setType(type);
        }
        if (json.has("ingredient")) {
            LazyIngredient material;
            JsonObject ingredient = JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient");
            if (ingredient.has("tag")) {
                String tag = JSONUtils.func_151200_h((JsonObject)ingredient, (String)"tag");
                material = LazyIngredient.tag((String)tag);
            } else if (ingredient.has("item")) {
                String item = JSONUtils.func_151200_h((JsonObject)ingredient, (String)"item");
                if (ingredient.has("nbt")) {
                    CompoundNBT nbt = ParsingUtils.parseNBT(ingredient.get("nbt"));
                    material = LazyIngredient.item((String)item, (CompoundNBT)nbt);
                } else {
                    material = LazyIngredient.item((String)item);
                }
            } else {
                throw new JsonSyntaxException("Ingredient must have either 'item' or 'tag' property");
            }
            crop.setCraftingMaterial(material);
        }
        if (json.has("enabled")) {
            boolean enabled = JSONUtils.func_151212_i((JsonObject)json, (String)"enabled");
            crop.setEnabled(enabled);
        }
        if (json.has("crux")) {
            if (json.get("crux").isJsonNull()) {
                CropLoader.CRUX_MAP.put(crop, null);
            } else {
                String crux = JSONUtils.func_151200_h((JsonObject)json, (String)"crux");
                CropLoader.CRUX_MAP.put(crop, new ResourceLocation(crux));
            }
        }
        if (json.has("glint")) {
            boolean glint = JSONUtils.func_151212_i((JsonObject)json, (String)"glint");
            crop.setHasEffect(glint);
        }
        if (json.has("biomes")) {
            JsonArray biomes = JSONUtils.func_151214_t((JsonObject)json, (String)"biomes");
            biomes.forEach(biome -> crop.addRequiredBiome(new ResourceLocation(biome.getAsString())));
        }
    }
}

