/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.util;

import com.blakebr0.mysticalagriculture.tileentity.EssenceFurnaceTileEntity;
import java.util.function.Supplier;

public enum FurnaceTier {
    INFERIUM("inferium", 0.84, 0.84, EssenceFurnaceTileEntity.Inferium::new),
    PRUDENTIUM("prudentium", 0.625, 0.84, EssenceFurnaceTileEntity.Prudentium::new),
    TERTIUM("tertium", 0.4, 0.68, EssenceFurnaceTileEntity.Tertium::new),
    IMPERIUM("imperium", 0.145, 0.5, EssenceFurnaceTileEntity.Imperium::new),
    SUPREMIUM("supremium", 0.025, 0.2, EssenceFurnaceTileEntity.Supremium::new);

    private final String name;
    private final double cookTimeMultiplier;
    private final double burnTimeMultiplier;
    private final Supplier<EssenceFurnaceTileEntity> tileEntitySupplier;

    private FurnaceTier(String name, double cookTimeMultiplier, double burnTimeMultiplier, Supplier<EssenceFurnaceTileEntity> tileEntitySupplier) {
        this.name = name;
        this.cookTimeMultiplier = cookTimeMultiplier;
        this.burnTimeMultiplier = burnTimeMultiplier;
        this.tileEntitySupplier = tileEntitySupplier;
    }

    public String getName() {
        return this.name;
    }

    public double getCookTimeMultiplier() {
        return this.cookTimeMultiplier;
    }

    public double getBurnTimeMultiplier() {
        return this.burnTimeMultiplier;
    }

    public EssenceFurnaceTileEntity getNewTileEntity() {
        return this.tileEntitySupplier.get();
    }
}

