/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.data.generator;

import com.blakebr0.mysticalagriculture.api.MysticalAgricultureAPI;
import com.blakebr0.mysticalagriculture.registry.CropRegistry;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.CropsBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class BlockModelJsonGenerator
extends BlockStateProvider {
    public BlockModelJsonGenerator(DataGenerator generator, String modid, ExistingFileHelper existingFileHelper) {
        super(generator, modid, existingFileHelper);
    }

    protected void registerStatesAndModels() {
        HashMap stemModels = new HashMap();
        MysticalAgricultureAPI.CROP_TYPES.forEach(type -> {
            ModelFile[] models = new ModelFile[8];
            ResourceLocation stemModel = type.getStemModel();
            for (int i = 0; i <= 7; ++i) {
                models[i] = new ModelFile.UncheckedModelFile(new ResourceLocation(stemModel.func_110624_b(), stemModel.func_110623_a() + "_" + i));
            }
            stemModels.put(type.getName(), models);
        });
        CropRegistry.getInstance().getCrops().forEach(crop -> {
            CropsBlock block = crop.getCrop();
            ModelFile[] models = (ModelFile[])stemModels.get(crop.getType().getName());
            this.getVariantBuilder((Block)block).forAllStates(state -> {
                Integer age = (Integer)state.func_177229_b((Property)CropsBlock.field_176488_a);
                if (age.intValue() == block.func_185526_g()) {
                    BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(crop.getNameWithSuffix("crop"))).parent(models[7])).texture("flower", crop.getTextures().getFlowerTexture());
                    return ConfiguredModel.builder().modelFile((ModelFile)model).build();
                }
                return ConfiguredModel.builder().modelFile(models[age]).build();
            });
        });
    }

    public String func_200397_b() {
        return "Mystical Agriculture block model generator";
    }
}

