/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.handler;

import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.mysticalagriculture.api.tinkering.ITinkerable;
import com.blakebr0.mysticalagriculture.config.ModConfigs;
import com.blakebr0.mysticalagriculture.init.ModItems;
import java.util.Collection;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class MobDropHandler {
    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        PlayerEntity player;
        Item item;
        LivingEntity entity = event.getEntityLiving();
        World world = entity.func_130014_f_();
        if (!world.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
            return;
        }
        Collection drops = event.getDrops();
        Entity attacker = event.getSource().func_76346_g();
        double inferiumDropChance = (Double)ModConfigs.INFERIUM_DROP_CHANCE.get();
        if (entity instanceof CreatureEntity && Math.random() < inferiumDropChance) {
            drops.add(new ItemEntity(world, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), new ItemStack((IItemProvider)ModItems.INFERIUM_ESSENCE.get())));
        }
        if (attacker instanceof PlayerEntity && (item = (player = (PlayerEntity)attacker).func_184614_ca().func_77973_b()) instanceof ITinkerable) {
            ItemStack stack;
            boolean dragonDropsEssence;
            ItemStack stack2;
            ITinkerable tinkerable = (ITinkerable)item;
            boolean witherDropsEssence = (Boolean)ModConfigs.WITHER_DROPS_ESSENCE.get();
            if (witherDropsEssence && entity instanceof WitherEntity && !(stack2 = MobDropHandler.getEssenceForTinkerable(tinkerable, 1, 3)).func_190926_b()) {
                drops.add(new ItemEntity(world, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), stack2));
            }
            if ((dragonDropsEssence = ((Boolean)ModConfigs.DRAGON_DROPS_ESSENCE.get()).booleanValue()) && entity instanceof EnderDragonEntity && !(stack = MobDropHandler.getEssenceForTinkerable(tinkerable, 2, 4)).func_190926_b()) {
                drops.add(new ItemEntity(world, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), stack));
            }
        }
    }

    private static ItemStack getEssenceForTinkerable(ITinkerable tinkerable, int min, int max) {
        switch (tinkerable.getTinkerableTier()) {
            case 1: {
                return new ItemStack((IItemProvider)ModItems.INFERIUM_ESSENCE.get(), Utils.randInt((int)min, (int)max));
            }
            case 2: {
                return new ItemStack((IItemProvider)ModItems.PRUDENTIUM_ESSENCE.get(), Utils.randInt((int)min, (int)max));
            }
            case 3: {
                return new ItemStack((IItemProvider)ModItems.TERTIUM_ESSENCE.get(), Utils.randInt((int)min, (int)max));
            }
            case 4: {
                return new ItemStack((IItemProvider)ModItems.IMPERIUM_ESSENCE.get(), Utils.randInt((int)min, (int)max));
            }
            case 5: {
                return new ItemStack((IItemProvider)ModItems.SUPREMIUM_ESSENCE.get(), Utils.randInt((int)min, (int)max));
            }
        }
        return ItemStack.field_190927_a;
    }
}

