/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting.ingredient;

import com.blakebr0.mysticalagriculture.init.ModRecipeSerializers;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.item.HoeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class HoeIngredient
extends Ingredient {
    public static final List<HoeItem> ALL_HOES = new ArrayList<HoeItem>();
    private ItemStack[] stacks;
    private IntList stacksPacked;

    public HoeIngredient() {
        super(Stream.of(new Ingredient.IItemList[0]));
    }

    public ItemStack[] func_193365_a() {
        if (this.stacks == null) {
            this.initMatchingStacks();
        }
        return this.stacks;
    }

    public IntList func_194139_b() {
        if (this.stacksPacked == null) {
            if (this.stacks == null) {
                this.initMatchingStacks();
            }
            this.stacksPacked = new IntArrayList(this.stacks.length);
            Arrays.stream(this.stacks).forEach(s -> this.stacksPacked.add(RecipeItemHelper.func_194113_b((ItemStack)s)));
            this.stacksPacked.sort((Comparator)IntComparators.NATURAL_COMPARATOR);
        }
        return this.stacksPacked;
    }

    public boolean test(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (ALL_HOES.size() == 0) {
            return stack.func_190926_b();
        }
        if (this.stacks == null) {
            this.initMatchingStacks();
        }
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.func_77973_b() != stack.func_77973_b()) continue;
            return true;
        }
        return false;
    }

    public boolean func_203189_d() {
        return !(!ALL_HOES.isEmpty() || this.stacks != null && this.stacks.length != 0 || this.stacksPacked != null && !this.stacksPacked.isEmpty());
    }

    public JsonElement func_200304_c() {
        JsonArray json = new JsonArray();
        ALL_HOES.stream().filter(h -> h.getRegistryName() != null).forEach(h -> {
            JsonObject obj = new JsonObject();
            obj.addProperty("item", h.getRegistryName().toString());
            json.add((JsonElement)obj);
        });
        return json;
    }

    protected void invalidate() {
        this.stacks = null;
        this.stacksPacked = null;
    }

    public boolean isSimple() {
        return true;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return ModRecipeSerializers.HOE_INGREDIENT;
    }

    private void initMatchingStacks() {
        this.stacks = (ItemStack[])ALL_HOES.stream().map(ItemStack::new).toArray(ItemStack[]::new);
    }

    public static class Serializer
    implements IIngredientSerializer<HoeIngredient> {
        public HoeIngredient parse(PacketBuffer buffer) {
            return new HoeIngredient();
        }

        public HoeIngredient parse(JsonObject json) {
            return new HoeIngredient();
        }

        public void write(PacketBuffer buffer, HoeIngredient ingredient) {
        }
    }
}

