/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.container;

import com.blakebr0.mysticalagriculture.api.tinkering.IAugment;
import com.blakebr0.mysticalagriculture.api.tinkering.IAugmentGetter;
import com.blakebr0.mysticalagriculture.api.util.AugmentUtils;
import com.blakebr0.mysticalagriculture.container.slot.AugmentSlot;
import com.blakebr0.mysticalagriculture.container.slot.ElementSlot;
import com.blakebr0.mysticalagriculture.container.slot.TinkerableSlot;
import com.blakebr0.mysticalagriculture.init.ModContainerTypes;
import com.blakebr0.mysticalagriculture.tileentity.TinkeringTableTileEntity;
import java.util.function.Function;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TinkeringTableContainer
extends Container {
    private final Function<PlayerEntity, Boolean> isUsableByPlayer;
    private final IItemHandlerModifiable inventory;

    private TinkeringTableContainer(ContainerType<?> type, int id, PlayerInventory playerInventory) {
        this(type, id, playerInventory, p -> false, (IItemHandlerModifiable)new TinkeringTableTileEntity().getInventory());
    }

    private TinkeringTableContainer(ContainerType<?> type, int id, PlayerInventory playerInventory, Function<PlayerEntity, Boolean> isUsableByPlayer, IItemHandlerModifiable inventory) {
        super(type, id);
        this.isUsableByPlayer = isUsableByPlayer;
        this.inventory = inventory;
        this.func_75146_a((Slot)new TinkerableSlot(this, (IItemHandler)inventory, 0, 80, 49));
        this.func_75146_a((Slot)new AugmentSlot(this, (IItemHandler)inventory, 1, 140, 36, 0));
        this.func_75146_a((Slot)new AugmentSlot(this, (IItemHandler)inventory, 2, 140, 62, 1));
        this.func_75146_a((Slot)new ElementSlot(this, (IItemHandler)inventory, 3, 20, 18));
        this.func_75146_a((Slot)new ElementSlot(this, (IItemHandler)inventory, 4, 20, 39));
        this.func_75146_a((Slot)new ElementSlot(this, (IItemHandler)inventory, 5, 20, 60));
        this.func_75146_a((Slot)new ElementSlot(this, (IItemHandler)inventory, 6, 20, 81));
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.func_75146_a(new Slot((IInventory)playerInventory, i1 + k * 9 + 9, 8 + i1 * 18, 115 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.func_75146_a(new Slot((IInventory)playerInventory, l, 8 + l * 18, 173));
        }
    }

    public void func_75130_a(IInventory inventory) {
        ItemStack tinkerable = this.inventory.getStackInSlot(0);
        if (!tinkerable.func_190926_b()) {
            for (int i = 0; i < 2; ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i + 1);
                Item item = stack.func_77973_b();
                IAugment augmentInSlot = AugmentUtils.getAugment(tinkerable, i);
                if (!stack.func_190926_b() && item instanceof IAugmentGetter) {
                    IAugment augment = ((IAugmentGetter)item).getAugment();
                    if (augment == augmentInSlot) continue;
                    AugmentUtils.addAugment(tinkerable, augment, i);
                    continue;
                }
                if (augmentInSlot == null) continue;
                AugmentUtils.removeAugment(tinkerable, i);
            }
        }
        super.func_75130_a(inventory);
    }

    public boolean func_75145_c(PlayerEntity player) {
        return this.isUsableByPlayer.apply(player);
    }

    public ItemStack func_82846_b(PlayerEntity player, int slotNumber) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotNumber);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (slotNumber == 0) {
                if (!this.func_75135_a(itemstack1, 7, 43, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (slotNumber >= 7 && slotNumber < 43 ? !this.func_75135_a(itemstack1, 0, 7, false) : !this.func_75135_a(itemstack1, 7, 43, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, itemstack1);
        }
        return itemstack;
    }

    public static TinkeringTableContainer create(int windowId, PlayerInventory playerInventory) {
        return new TinkeringTableContainer((ContainerType)ModContainerTypes.TINKERING_TABLE.get(), windowId, playerInventory);
    }

    public static TinkeringTableContainer create(int windowId, PlayerInventory playerInventory, Function<PlayerEntity, Boolean> isUsableByPlayer, IItemHandlerModifiable inventory) {
        return new TinkeringTableContainer((ContainerType)ModContainerTypes.TINKERING_TABLE.get(), windowId, playerInventory, isUsableByPlayer, inventory);
    }
}

