/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.client.screen;

import com.blakebr0.cucumber.client.screen.BaseContainerScreen;
import com.blakebr0.mysticalagriculture.container.SoulExtractorContainer;
import com.blakebr0.mysticalagriculture.tileentity.SoulExtractorTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class SoulExtractorScreen
extends BaseContainerScreen<SoulExtractorContainer> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("mysticalagriculture", "textures/gui/soul_extractor.png");
    private SoulExtractorTileEntity tile;

    public SoulExtractorScreen(SoulExtractorContainer container, PlayerInventory inv, ITextComponent title) {
        super((Container)container, inv, title, BACKGROUND, 176, 194);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.tile = this.getTileEntity();
    }

    protected void func_230451_b_(MatrixStack stack, int mouseX, int mouseY) {
        String title = this.func_231171_q_().getString();
        this.field_230712_o_.func_238421_b_(stack, title, (float)(this.field_146999_f / 2 - this.field_230712_o_.func_78256_a(title) / 2), 6.0f, 0x404040);
        String inventory = this.field_213127_e.func_145748_c_().getString();
        this.field_230712_o_.func_238421_b_(stack, inventory, 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
    }

    protected void func_230450_a_(MatrixStack stack, float partialTicks, int mouseX, int mouseY) {
        super.func_230450_a_(stack, partialTicks, mouseX, mouseY);
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        int i1 = this.getEnergyBarScaled(78);
        this.func_238474_b_(stack, x + 7, y + 95 - i1, 176, 109 - i1, 15, i1);
        if (this.getFuelItemValue() > 0) {
            int lol = this.getBurnLeftScaled(13);
            this.func_238474_b_(stack, x + 31, y + 52 - lol, 176, 12 - lol, 14, lol + 1);
        }
        if (this.getProgress() > 0) {
            int i2 = this.getProgressScaled(24);
            this.func_238474_b_(stack, x + 98, y + 51, 176, 14, i2 + 1, 16);
        }
    }

    protected void func_230459_a_(MatrixStack stack, int mouseX, int mouseY) {
        StringTextComponent text;
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        super.func_230459_a_(stack, mouseX, mouseY);
        if (mouseX > x + 7 && mouseX < x + 20 && mouseY > y + 17 && mouseY < y + 94) {
            text = new StringTextComponent(SoulExtractorScreen.number((Object)this.getEnergyStored()) + " / " + SoulExtractorScreen.number((Object)this.getMaxEnergyStored()) + " FE");
            this.func_238652_a_(stack, (ITextComponent)text, mouseX, mouseY);
        }
        if (mouseX > x + 30 && mouseX < x + 45 && mouseY > y + 39 && mouseY < y + 53) {
            text = new StringTextComponent(SoulExtractorScreen.number((Object)this.getFuelLeft()) + " FE");
            this.func_238652_a_(stack, (ITextComponent)text, mouseX, mouseY);
        }
    }

    private SoulExtractorTileEntity getTileEntity() {
        TileEntity tile;
        ClientWorld world = this.getMinecraft().field_71441_e;
        if (world != null && (tile = world.func_175625_s(((SoulExtractorContainer)this.func_212873_a_()).getPos())) instanceof SoulExtractorTileEntity) {
            return (SoulExtractorTileEntity)tile;
        }
        return null;
    }

    public int getProgress() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getProgress();
    }

    public int getOperationTime() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getOperationTime();
    }

    public int getFuelLeft() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getFuelLeft();
    }

    public int getFuelItemValue() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getFuelItemValue();
    }

    public int getEnergyStored() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getEnergy().getEnergyStored();
    }

    public int getMaxEnergyStored() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getEnergy().getMaxEnergyStored();
    }

    public int getProgressScaled(int pixels) {
        int i = this.getProgress();
        int j = this.getOperationTime();
        return j != 0 && i != 0 ? i * pixels / j : 0;
    }

    public int getEnergyBarScaled(int pixels) {
        int i = this.getEnergyStored();
        int j = this.getMaxEnergyStored();
        return (int)(j != 0 && i != 0 ? (long)i * (long)pixels / (long)j : 0L);
    }

    public int getBurnLeftScaled(int pixels) {
        int i = this.getFuelLeft();
        int j = this.getFuelItemValue();
        return (int)(j != 0 && i != 0 ? (long)i * (long)pixels / (long)j : 0L);
    }
}

