/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.api.util;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ExperienceCapsuleUtils {
    private static final RegistryObject<Item> EXPERIENCE_CAPSULE = RegistryObject.of((ResourceLocation)new ResourceLocation("mysticalagriculture", "experience_capsule"), (IForgeRegistry)ForgeRegistries.ITEMS);
    public static final int MAX_XP_POINTS = 1200;

    public static CompoundNBT makeTag(int xp) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("Experience", Math.min(1200, xp));
        return nbt;
    }

    public static ItemStack getExperienceCapsule(int xp) {
        CompoundNBT nbt = ExperienceCapsuleUtils.makeTag(xp);
        ItemStack stack = new ItemStack((IItemProvider)EXPERIENCE_CAPSULE.get());
        stack.func_77982_d(nbt);
        return stack;
    }

    public static int getExperience(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("Experience")) {
            return nbt.func_74762_e("Experience");
        }
        return 0;
    }

    public static int addExperienceToCapsule(ItemStack stack, int amount) {
        int xp = ExperienceCapsuleUtils.getExperience(stack);
        if (xp >= 1200) {
            return amount;
        }
        int newAmount = Math.min(1200, xp + amount);
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null) {
            CompoundNBT tag = ExperienceCapsuleUtils.makeTag(newAmount);
            stack.func_77982_d(tag);
        } else {
            nbt.func_74768_a("Experience", newAmount);
        }
        return Math.max(0, amount - (newAmount - xp));
    }
}

