/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.tile_entities;

import com.alc.moreminecarts.MMReferences;
import com.alc.moreminecarts.containers.MinecartUnLoaderContainer;
import com.alc.moreminecarts.entities.ChunkLoaderCartEntity;
import com.alc.moreminecarts.tile_entities.AbstractCommonLoader;
import com.alc.moreminecarts.tile_entities.LockingRailTile;
import java.util.List;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.item.minecart.ContainerMinecartEntity;
import net.minecraft.entity.item.minecart.FurnaceMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class MinecartLoaderTile
extends AbstractCommonLoader
implements ITickableTileEntity {
    public MinecartLoaderTile() {
        super(MMReferences.minecart_loader_te);
        this.last_redstone_output = !this.redstone_output;
    }

    @Override
    public boolean getIsUnloader() {
        return false;
    }

    public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
        this.changed_flag = true;
        return new MinecartUnLoaderContainer(i, this.field_145850_b, this.field_174879_c, inventory, player);
    }

    protected Container func_213906_a(int p_213906_1_, PlayerInventory p_213906_2_) {
        return null;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isOnCooldown()) {
                int new_comparator_output_value;
                List<AbstractMinecartEntity> minecarts = this.getLoadableMinecartsInRange();
                float criteria_total = 0.0f;
                for (AbstractMinecartEntity minecart : minecarts) {
                    LazyOptional tankCapability = minecart.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
                    LazyOptional energyCapability = minecart.getCapability(CapabilityEnergy.ENERGY);
                    if (tankCapability.isPresent()) {
                        IFluidHandler fluid_handler = (IFluidHandler)tankCapability.orElse(null);
                        criteria_total += this.doFluidLoads(fluid_handler);
                        continue;
                    }
                    if (energyCapability.isPresent()) {
                        IEnergyStorage energy_storage = (IEnergyStorage)energyCapability.orElse(null);
                        criteria_total += this.doElectricLoads(energy_storage);
                        continue;
                    }
                    if (minecart instanceof ContainerMinecartEntity) {
                        criteria_total += this.doMinecartLoads((ContainerMinecartEntity)minecart);
                        continue;
                    }
                    if (!(minecart instanceof FurnaceMinecartEntity)) continue;
                    criteria_total += this.doFuranceCartLoads((FurnaceMinecartEntity)minecart);
                }
                criteria_total = minecarts.size() == 0 ? 0.0f : (criteria_total /= (float)minecarts.size());
                if (this.comparator_output != AbstractCommonLoader.ComparatorOutputType.cart_fullness) {
                    criteria_total = (float)Math.floor(criteria_total);
                }
                if ((new_comparator_output_value = (int)(criteria_total * 15.0f)) != this.comparator_output_value || this.last_redstone_output != this.redstone_output) {
                    this.comparator_output_value = new_comparator_output_value;
                    this.last_redstone_output = this.redstone_output;
                    this.field_145850_b.func_175666_e(this.func_174877_v(), this.func_195044_w().func_177230_c());
                    this.field_145850_b.func_195593_d(this.func_174877_v(), this.func_195044_w().func_177230_c());
                }
            } else {
                this.decCooldown();
            }
            if (this.changed_flag) {
                this.func_70296_d();
                this.changed_flag = false;
            }
        }
    }

    public float doFluidLoads(IFluidHandler minecart_handler) {
        boolean changed = false;
        IFluidHandler our_fluid_handler = (IFluidHandler)this.fluid_handler.orElse(null);
        FluidStack our_fluid_stack = our_fluid_handler.getFluidInTank(0);
        float fluid_content_proportion = 0.0f;
        for (int i = 0; i < minecart_handler.getTanks(); ++i) {
            if (minecart_handler.getTankCapacity(i) > 0) {
                fluid_content_proportion += (float)minecart_handler.getFluidInTank(i).getAmount() / (float)minecart_handler.getTankCapacity(i);
            }
            if (our_fluid_stack.getAmount() <= (this.leave_one_in_stack ? 1 : 0)) continue;
            boolean did_load = false;
            if (minecart_handler.isFluidValid(i, our_fluid_stack)) {
                FluidStack add_to_stack = minecart_handler.getFluidInTank(i);
                if (add_to_stack.isEmpty()) {
                    FluidStack new_stack = our_fluid_stack.copy();
                    int transfer_amount = Math.min(1000, new_stack.getAmount());
                    new_stack.setAmount(transfer_amount);
                    minecart_handler.fill(new_stack, IFluidHandler.FluidAction.EXECUTE);
                    our_fluid_stack.shrink(transfer_amount);
                    did_load = true;
                } else if (add_to_stack.isFluidEqual(our_fluid_stack)) {
                    int true_count = our_fluid_stack.getAmount() - (this.leave_one_in_stack ? 1 : 0);
                    int to_fill = minecart_handler.getTankCapacity(i) - add_to_stack.getAmount();
                    int transfer = Math.min(1000, Math.min(true_count, to_fill));
                    FluidStack adding_stack = add_to_stack.copy();
                    adding_stack.setAmount(transfer);
                    minecart_handler.fill(adding_stack, IFluidHandler.FluidAction.EXECUTE);
                    our_fluid_stack.shrink(transfer);
                    boolean bl = did_load = transfer > 0;
                }
            }
            if (!did_load) continue;
            changed = true;
            break;
        }
        if (minecart_handler.getTanks() > 0) {
            fluid_content_proportion /= (float)minecart_handler.getTanks();
        }
        if (changed) {
            this.resetCooldown();
            this.changed_flag = true;
        }
        if (this.comparator_output == AbstractCommonLoader.ComparatorOutputType.done_loading) {
            return changed ? 0.0f : 1.0f;
        }
        return fluid_content_proportion;
    }

    public float doElectricLoads(IEnergyStorage minecart_handler) {
        boolean changed = false;
        IEnergyStorage our_handler = (IEnergyStorage)this.energy_handler.orElse(null);
        if (minecart_handler.canReceive()) {
            int true_count = our_handler.getEnergyStored() - (this.leave_one_in_stack ? 1 : 0);
            int to_fill = minecart_handler.getMaxEnergyStored() - minecart_handler.getEnergyStored();
            int transfer = Math.min(1000, Math.min(true_count, to_fill));
            minecart_handler.receiveEnergy(transfer, false);
            our_handler.extractEnergy(transfer, false);
            boolean bl = changed = transfer > 0;
        }
        if (changed) {
            this.resetCooldown();
            this.changed_flag = true;
        }
        if (this.comparator_output == AbstractCommonLoader.ComparatorOutputType.done_loading) {
            return changed ? 0.0f : 1.0f;
        }
        return (float)minecart_handler.getEnergyStored() / (float)minecart_handler.getMaxEnergyStored();
    }

    public float doMinecartLoads(ContainerMinecartEntity minecart) {
        boolean changed = false;
        block0: for (ItemStack stack : this.items) {
            if (stack.func_190926_b() || this.leave_one_in_stack && stack.func_190916_E() == 1) continue;
            for (int i = 0; i < minecart.func_70302_i_() && !stack.func_190926_b(); ++i) {
                boolean did_load = false;
                if (minecart.func_94041_b(i, stack)) {
                    ItemStack add_to_stack = minecart.func_70301_a(i);
                    if (add_to_stack.func_190926_b()) {
                        ItemStack new_stack = stack.func_77946_l();
                        int transfer_amount = Math.min(8, new_stack.func_190916_E());
                        new_stack.func_190920_e(transfer_amount);
                        minecart.func_70299_a(i, new_stack);
                        stack.func_190918_g(transfer_amount);
                        did_load = true;
                    } else if (MinecartLoaderTile.canMergeItems(add_to_stack, stack)) {
                        int true_count = stack.func_190916_E() - (this.leave_one_in_stack ? 1 : 0);
                        int to_fill = add_to_stack.func_77976_d() - add_to_stack.func_190916_E();
                        int transfer = Math.min(8, Math.min(true_count, to_fill));
                        stack.func_190918_g(transfer);
                        add_to_stack.func_190917_f(transfer);
                        boolean bl = did_load = transfer > 0;
                    }
                }
                if (!did_load) continue;
                changed = true;
                continue block0;
            }
        }
        if (changed) {
            this.resetCooldown();
            this.changed_flag = true;
        }
        if (this.comparator_output == AbstractCommonLoader.ComparatorOutputType.done_loading) {
            return changed ? 0.0f : 1.0f;
        }
        if (minecart instanceof ChunkLoaderCartEntity && this.comparator_output == AbstractCommonLoader.ComparatorOutputType.cart_fullness) {
            return (float)((ChunkLoaderCartEntity)minecart).getComparatorSignal() / 15.0f;
        }
        return (float)Container.func_94526_b((IInventory)minecart) / 15.0f;
    }

    public float doFuranceCartLoads(FurnaceMinecartEntity minecart) {
        boolean changed = false;
        TileEntity te_at_minecart = this.field_145850_b.func_175625_s(minecart.getCurrentRailPosition());
        if (te_at_minecart instanceof LockingRailTile && ((LockingRailTile)te_at_minecart).locked_minecart == minecart) {
            LockingRailTile locking_rail_tile = (LockingRailTile)te_at_minecart;
            if (locking_rail_tile.saved_fuel + 3600 <= 32000) {
                for (ItemStack stack : this.items) {
                    if (!Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151044_h, Items.field_196155_l}).test(stack) || this.leave_one_in_stack && stack.func_190916_E() == 1) continue;
                    stack.func_190918_g(1);
                    locking_rail_tile.saved_fuel += 3600;
                    changed = true;
                }
            }
        } else {
            if (minecart.field_94110_c + 3600 <= 32000) {
                for (ItemStack stack : this.items) {
                    if (!Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151044_h, Items.field_196155_l}).test(stack) || this.leave_one_in_stack && stack.func_190916_E() == 1) continue;
                    stack.func_190918_g(1);
                    minecart.field_94110_c += 3600;
                    changed = true;
                }
            }
            if (minecart.field_94111_a == 0.0 && minecart.field_94109_b == 0.0) {
                minecart.field_94111_a = minecart.func_213322_ci().field_72450_a;
                minecart.field_94109_b = minecart.func_213322_ci().field_72449_c;
            }
        }
        if (changed) {
            this.resetCooldown();
            this.changed_flag = true;
        }
        if (this.comparator_output == AbstractCommonLoader.ComparatorOutputType.done_loading) {
            return changed ? 0.0f : 1.0f;
        }
        float fullness = Math.min((float)minecart.field_94110_c / 28400.0f, 1.0f);
        if (this.comparator_output == AbstractCommonLoader.ComparatorOutputType.cart_full) {
            fullness = (float)Math.floor(fullness);
        }
        return fullness;
    }

    protected ITextComponent func_213907_g() {
        return new StringTextComponent("Minecart Loader");
    }
}

