/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.tile_entities;

import com.alc.moreminecarts.MMConstants;
import com.alc.moreminecarts.MMItemReferences;
import com.alc.moreminecarts.MMReferences;
import com.alc.moreminecarts.blocks.containers.ChunkLoaderBlock;
import com.alc.moreminecarts.containers.ChunkLoaderContainer;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.world.ForgeChunkManager;

public class ChunkLoaderTile
extends LockableTileEntity
implements ISidedInventory,
ITickableTileEntity,
INamedContainerProvider {
    public static String LAST_CHUNK_X_PROPERTY = "last_block_pos_x";
    public static String LAST_CHUNK_Z_PROPERTY = "last_block_pos_z";
    public static String TIME_LEFT_PROPERTY = "time_left";
    public static int MAX_TIME = 10368000;
    public static int MAX_MINUTES = 8640;
    protected NonNullList<ItemStack> items = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    public final IIntArray dataAccess = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return (int)Math.ceil((double)(Math.abs(ChunkLoaderTile.this.time_left) - 1) / 1200.0) * this.func_221476_a(1);
                }
                case 1: {
                    return ChunkLoaderTile.this.time_left > 0 ? 1 : -1;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int set_to) {
            switch (index) {
                case 0: {
                    ChunkLoaderTile.this.time_left = set_to * 1200;
                    break;
                }
                case 1: {
                    ChunkLoaderTile.this.time_left = Math.abs(ChunkLoaderTile.this.time_left) * (set_to > 0 ? 1 : -1);
                    break;
                }
            }
        }

        public int func_221478_a() {
            return 2;
        }
    };
    public boolean lit_last_tick = false;
    public int time_left = -1;
    public int last_chunk_x = this.func_174877_v().func_177958_n() >> 4;
    public int last_chunk_z = this.func_174877_v().func_177952_p() >> 4;

    public ChunkLoaderTile() {
        super(MMReferences.chunk_loader_te);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a(LAST_CHUNK_X_PROPERTY, this.last_chunk_x);
        compound.func_74768_a(LAST_CHUNK_Z_PROPERTY, this.last_chunk_z);
        compound.func_74768_a(TIME_LEFT_PROPERTY, this.time_left);
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.items);
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.last_chunk_x = compound.func_74762_e(LAST_CHUNK_X_PROPERTY);
        this.last_chunk_z = compound.func_74762_e(LAST_CHUNK_Z_PROPERTY);
        this.time_left = compound.func_74762_e(TIME_LEFT_PROPERTY);
        this.lit_last_tick = this.isLit();
        ItemStackHelper.func_191283_b((CompoundNBT)compound, this.items);
        super.func_230337_a_(state, compound);
    }

    public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
        return new ChunkLoaderContainer(i, this.field_145850_b, this.field_174879_c, inventory, player);
    }

    protected Container func_213906_a(int p_213906_1_, PlayerInventory p_213906_2_) {
        return null;
    }

    public static int getBurnDuration(Item item) {
        double multiplier = (Double)MMConstants.CONFIG_CHUNK_LOADER_MULTIPLIER.get();
        double fuel = -1.0;
        if (item == Items.field_151128_bU) {
            fuel = 600.0;
        } else if (item == Items.field_151166_bC) {
            fuel = 6000.0;
        } else if (item == Items.field_221739_dF) {
            fuel = 54000.0;
        } else if (item == Items.field_151045_i) {
            fuel = 72000.0;
        } else if (item == Items.field_221732_cb) {
            fuel = 648000.0;
        } else if (item == Items.field_151156_bN) {
            fuel = 3456000.0;
        } else if (item == MMItemReferences.chunkrodite) {
            fuel = 18000.0;
        } else if (item == MMItemReferences.chunkrodite_block) {
            fuel = 162000.0;
        }
        fuel *= multiplier;
        if (fuel <= 0.0) {
            return -1;
        }
        return (int)Math.ceil(fuel);
    }

    public void func_73660_a() {
        boolean changed_flag = false;
        if (this.isLit()) {
            --this.time_left;
        }
        if (!this.field_145850_b.func_201670_d()) {
            int burn_duration = ChunkLoaderTile.getBurnDuration(((ItemStack)this.items.get(0)).func_77973_b());
            if (burn_duration >= 0 && Math.abs(this.time_left) + burn_duration <= MAX_TIME) {
                changed_flag = true;
                this.time_left = this.time_left > 0 ? (this.time_left += burn_duration) : (this.time_left -= burn_duration);
                ((ItemStack)this.items.get(0)).func_190918_g(1);
            }
            int chunk_x = this.func_174877_v().func_177958_n() >> 4;
            int chunk_z = this.func_174877_v().func_177952_p() >> 4;
            if (chunk_x != this.last_chunk_x || chunk_z != this.last_chunk_z) {
                changed_flag = true;
                this.forceChucksAt(this.last_chunk_x, this.last_chunk_z, false);
                this.last_chunk_x = chunk_x;
                this.last_chunk_z = chunk_z;
                boolean bl = this.lit_last_tick = !this.isLit();
            }
            if (this.lit_last_tick != this.isLit()) {
                changed_flag = true;
                if (this.isLit()) {
                    this.forceChucksAt(chunk_x, chunk_z, true);
                } else {
                    this.forceChucksAt(chunk_x, chunk_z, false);
                }
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)ChunkLoaderBlock.POWERED, (Comparable)Boolean.valueOf(this.isLit())), 3);
            }
            if (changed_flag) {
                this.func_70296_d();
            }
        }
        this.lit_last_tick = this.isLit();
    }

    private void forceChucksAt(int chunk_x, int chunk_z, boolean add) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                ForgeChunkManager.forceChunk((ServerWorld)((ServerWorld)this.field_145850_b), (String)"moreminecarts", (BlockPos)this.func_174877_v(), (int)(chunk_x + i), (int)(chunk_z + j), (boolean)add, (boolean)true);
            }
        }
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            int chunk_x = this.func_174877_v().func_177958_n() >> 4;
            int chunk_z = this.func_174877_v().func_177952_p() >> 4;
            this.forceChucksAt(chunk_x, chunk_z, false);
        }
        super.func_145843_s();
    }

    public boolean isLit() {
        return this.time_left > 1 && this.isEnabled();
    }

    public boolean isEnabled() {
        return this.time_left > 0;
    }

    public int[] func_180463_a(Direction p_180463_1_) {
        return new int[0];
    }

    public boolean func_180462_a(int p_180462_1_, ItemStack p_180462_2_, @Nullable Direction p_180462_3_) {
        return true;
    }

    public boolean func_180461_b(int p_180461_1_, ItemStack p_180461_2_, Direction p_180461_3_) {
        return false;
    }

    public int func_70302_i_() {
        return 1;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int p_70301_1_) {
        return (ItemStack)this.items.get(p_70301_1_);
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        return ItemStackHelper.func_188382_a(this.items, (int)p_70298_1_, (int)p_70298_2_);
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        return ItemStackHelper.func_188383_a(this.items, (int)p_70304_1_);
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
        this.items.set(p_70299_1_, (Object)p_70299_2_);
        if (p_70299_2_.func_190916_E() > this.func_70297_j_()) {
            p_70299_2_.func_190920_e(this.func_70297_j_());
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174888_l() {
        this.items.clear();
    }

    protected ITextComponent func_213907_g() {
        return new StringTextComponent("Chunk Loader");
    }

    public static void dropExtras(World world, int time_left, BlockPos pos) {
        double multiplier = (Double)MMConstants.CONFIG_CHUNK_LOADER_MULTIPLIER.get();
        if (multiplier == 0.0) {
            return;
        }
        int count = (int)Math.floor(Math.abs((double)time_left / multiplier) / 24000.0);
        Item to_drop = MMItemReferences.chunkrodite;
        if (count > 64) {
            count = (int)Math.floor((float)count / 9.0f);
            to_drop = MMItemReferences.chunkrodite_block;
            if (count > 64) {
                count = 64;
            }
        }
        if (count != 0) {
            ItemStack drop_stack = new ItemStack((IItemProvider)to_drop, count);
            NonNullList drops = NonNullList.func_191197_a((int)1, (Object)drop_stack);
            InventoryHelper.func_219961_a((World)world, (BlockPos)pos, (NonNullList)drops);
        }
    }

    public int getComparatorSignal() {
        float true_time_left = Math.abs(this.time_left) - 1;
        double log_proportion = Math.log10(true_time_left / (float)MAX_TIME * 9.0f + 1.0f);
        return (int)Math.ceil(log_proportion * 15.0);
    }
}

