/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.tile_entities;

import com.alc.moreminecarts.misc.SettableEnergyStorage;
import com.alc.moreminecarts.tile_entities.LockingRailTile;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public abstract class AbstractCommonLoader
extends LockableTileEntity {
    public static int MAX_COOLDOWN_TIME = 2;
    public static int FLUID_CAPACITY = 2000;
    public static int ENERGY_CAPACITY = 2000;
    public static String ENERGY_PROPERTY = "energy";
    public static String REDSTONE_OUTPUT_PROPERTY = "redstone_output";
    public static String LOCKED_MINECARTS_ONLY_PROPERTY = "locked_minecarts_only";
    public static String LEAVE_ONE_IN_STACK_PROPERTY = "leave_one_in_stack";
    public static String COMPARATOR_OUTPUT_PROPERTY = "comparator_output";
    public static String COOLDOWN_PROPERTY = "cooldown";
    protected NonNullList<ItemStack> items = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
    public final IIntArray dataAccess = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return (AbstractCommonLoader.this.locked_minecarts_only ? 1 : 0) + ((AbstractCommonLoader.this.leave_one_in_stack ? 1 : 0) << 1) + (AbstractCommonLoader.this.comparator_output.toInt() << 2) + ((AbstractCommonLoader.this.redstone_output ? 1 : 0) << 4);
                }
                case 1: {
                    return AbstractCommonLoader.this.getIsUnloader() ? 1 : 0;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int set_to) {
            switch (index) {
                case 0: {
                    AbstractCommonLoader.this.locked_minecarts_only = set_to % 2 == 1;
                    AbstractCommonLoader.this.leave_one_in_stack = (set_to & 2) == 2;
                    AbstractCommonLoader.this.comparator_output = ComparatorOutputType.fromInt((set_to & 0xC) >> 2);
                    AbstractCommonLoader.this.redstone_output = (set_to & 0x10) == 16;
                    break;
                }
            }
        }

        public int func_221478_a() {
            return 2;
        }
    };
    public boolean redstone_output;
    public boolean locked_minecarts_only = false;
    public boolean leave_one_in_stack = false;
    public ComparatorOutputType comparator_output;
    public boolean last_redstone_output;
    public int comparator_output_value = -1;
    public int cooldown_time;
    public boolean changed_flag;
    LazyOptional<IFluidHandler> fluid_handler = LazyOptional.of(() -> new LoaderTank(FLUID_CAPACITY));
    LazyOptional<IEnergyStorage> energy_handler = LazyOptional.of(() -> new LoaderBattery(ENERGY_CAPACITY));

    public abstract boolean getIsUnloader();

    public AbstractCommonLoader(TileEntityType<?> p_i48285_1_) {
        super(p_i48285_1_);
        this.comparator_output = ComparatorOutputType.done_loading;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluid_handler.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energy_handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74757_a(LOCKED_MINECARTS_ONLY_PROPERTY, this.locked_minecarts_only);
        compound.func_74757_a(LEAVE_ONE_IN_STACK_PROPERTY, this.leave_one_in_stack);
        compound.func_74757_a(REDSTONE_OUTPUT_PROPERTY, this.redstone_output);
        compound.func_74768_a(COMPARATOR_OUTPUT_PROPERTY, this.comparator_output.toInt());
        compound.func_74768_a(COOLDOWN_PROPERTY, this.cooldown_time);
        ((FluidTank)this.fluid_handler.orElse(null)).writeToNBT(compound);
        compound.func_74768_a(ENERGY_PROPERTY, ((IEnergyStorage)this.energy_handler.orElse(null)).getEnergyStored());
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.items);
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.locked_minecarts_only = compound.func_74767_n(LOCKED_MINECARTS_ONLY_PROPERTY);
        this.leave_one_in_stack = compound.func_74767_n(LEAVE_ONE_IN_STACK_PROPERTY);
        this.redstone_output = compound.func_74767_n(REDSTONE_OUTPUT_PROPERTY);
        this.comparator_output = ComparatorOutputType.fromInt(compound.func_74762_e(COMPARATOR_OUTPUT_PROPERTY));
        this.cooldown_time = compound.func_74762_e(COOLDOWN_PROPERTY);
        this.comparator_output_value = -1;
        this.last_redstone_output = !this.redstone_output;
        FluidTank tank = (FluidTank)this.fluid_handler.orElseGet(null);
        tank.setFluid(tank.readFromNBT(compound).getFluid());
        ((IEnergyStorage)this.energy_handler.orElse(null)).receiveEnergy(compound.func_74762_e(ENERGY_PROPERTY), false);
        this.changed_flag = true;
        ItemStackHelper.func_191283_b((CompoundNBT)compound, this.items);
        super.func_230337_a_(state, compound);
    }

    protected List<AbstractMinecartEntity> getLoadableMinecartsInRange() {
        if (this.locked_minecarts_only) {
            TileEntity te_below;
            ArrayList<AbstractMinecartEntity> acc = new ArrayList<AbstractMinecartEntity>();
            TileEntity te_above = this.field_145850_b.func_175625_s(this.func_174877_v().func_177984_a());
            if (te_above instanceof LockingRailTile && ((LockingRailTile)te_above).locked_minecart != null) {
                acc.add(((LockingRailTile)te_above).locked_minecart);
            }
            if ((te_below = this.field_145850_b.func_175625_s(this.func_174877_v().func_177977_b())) instanceof LockingRailTile && ((LockingRailTile)te_below).locked_minecart != null) {
                acc.add(((LockingRailTile)te_below).locked_minecart);
            }
            return acc;
        }
        return this.field_145850_b.func_175647_a(AbstractMinecartEntity.class, this.getDectectionBox(), entity -> true);
    }

    protected AxisAlignedBB getDectectionBox() {
        BlockPos pos = this.func_174877_v();
        double d0 = 0.2;
        return new AxisAlignedBB((double)pos.func_177958_n() + 0.2, (double)pos.func_177956_o() - 1.0, (double)pos.func_177952_p() + 0.2, (double)(pos.func_177958_n() + 1) - 0.2, (double)(pos.func_177956_o() + 2) - 0.2, (double)(pos.func_177952_p() + 1) - 0.2);
    }

    protected static boolean canMergeItems(ItemStack p_145894_0_, ItemStack p_145894_1_) {
        if (p_145894_0_.func_77973_b() != p_145894_1_.func_77973_b()) {
            return false;
        }
        if (p_145894_0_.func_77952_i() != p_145894_1_.func_77952_i()) {
            return false;
        }
        return p_145894_0_.func_190916_E() > p_145894_0_.func_77976_d() ? false : ItemStack.func_77970_a((ItemStack)p_145894_0_, (ItemStack)p_145894_1_);
    }

    public void resetCooldown() {
        this.cooldown_time = MAX_COOLDOWN_TIME;
    }

    public boolean isOnCooldown() {
        return this.cooldown_time != 0;
    }

    public void decCooldown() {
        --this.cooldown_time;
        if (this.cooldown_time < 0) {
            this.cooldown_time = 0;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.fluid_handler.invalidate();
        this.energy_handler.invalidate();
    }

    public FluidStack getFluidStack() {
        return ((IFluidHandler)this.fluid_handler.orElse(null)).getFluidInTank(0);
    }

    public int getEnergyAmount() {
        return ((IEnergyStorage)this.energy_handler.resolve().get()).getEnergyStored();
    }

    public int[] getSlotsForFace(Direction p_180463_1_) {
        return new int[0];
    }

    public boolean canPlaceItemThroughFace(int p_180462_1_, ItemStack p_180462_2_, @Nullable Direction p_180462_3_) {
        return true;
    }

    public boolean canTakeItemThroughFace(int p_180461_1_, ItemStack p_180461_2_, Direction p_180461_3_) {
        return false;
    }

    public int func_70302_i_() {
        return 9;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int p_70301_1_) {
        return (ItemStack)this.items.get(p_70301_1_);
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        return ItemStackHelper.func_188382_a(this.items, (int)p_70298_1_, (int)p_70298_2_);
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        return ItemStackHelper.func_188383_a(this.items, (int)p_70304_1_);
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
        this.items.set(p_70299_1_, (Object)p_70299_2_);
        if (p_70299_2_.func_190916_E() > this.func_70297_j_()) {
            p_70299_2_.func_190920_e(this.func_70297_j_());
        }
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT compound = new CompoundNBT();
        ((FluidTank)this.fluid_handler.orElse(null)).writeToNBT(compound);
        compound.func_74768_a(ENERGY_PROPERTY, ((IEnergyStorage)this.energy_handler.orElse(null)).getEnergyStored());
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, compound);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT compound = pkt.func_148857_g();
        FluidTank tank = (FluidTank)this.fluid_handler.resolve().get();
        tank.setFluid(tank.readFromNBT(compound).getFluid());
        ((SettableEnergyStorage)((Object)this.energy_handler.orElse(null))).setEnergy(compound.func_74762_e(ENERGY_PROPERTY));
    }

    public void func_70296_d() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            super.func_70296_d();
            this.field_145850_b.markAndNotifyBlock(this.func_174877_v(), this.field_145850_b.func_175726_f(this.func_174877_v()), this.func_195044_w(), this.func_195044_w(), 2, 0);
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174888_l() {
        this.items.clear();
    }

    public boolean getOutputsRedstone() {
        return this.redstone_output;
    }

    public int getSignal() {
        if (this.comparator_output_value < 0) {
            return 0;
        }
        return this.comparator_output_value;
    }

    public class LoaderBattery
    extends SettableEnergyStorage {
        public LoaderBattery(int capacity) {
            super(capacity);
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int ret = super.receiveEnergy(maxReceive, simulate);
            if (!simulate) {
                AbstractCommonLoader.this.changed_flag = true;
            }
            return ret;
        }

        public int extractEnergy(int maxReceive, boolean simulate) {
            int ret = super.extractEnergy(maxReceive, simulate);
            if (!simulate) {
                AbstractCommonLoader.this.changed_flag = true;
            }
            return ret;
        }
    }

    public class LoaderTank
    extends FluidTank {
        public LoaderTank(int capacity) {
            super(capacity);
        }

        protected void onContentsChanged() {
            super.onContentsChanged();
            AbstractCommonLoader.this.changed_flag = true;
        }
    }

    public static enum ComparatorOutputType {
        done_loading,
        cart_full,
        cart_fullness;


        public int toInt() {
            switch (this) {
                case done_loading: {
                    return 0;
                }
                case cart_full: {
                    return 1;
                }
                case cart_fullness: {
                    return 2;
                }
            }
            return 3;
        }

        public static ComparatorOutputType next(ComparatorOutputType in) {
            switch (in) {
                case done_loading: {
                    return cart_full;
                }
                case cart_full: {
                    return cart_fullness;
                }
                case cart_fullness: {
                    return done_loading;
                }
            }
            return done_loading;
        }

        public static ComparatorOutputType fromInt(int n) {
            if (n == 0) {
                return done_loading;
            }
            if (n == 1) {
                return cart_full;
            }
            return cart_fullness;
        }
    }
}

