/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.entities;

import com.alc.moreminecarts.MMItemReferences;
import com.alc.moreminecarts.MMReferences;
import com.alc.moreminecarts.blocks.PistonDisplayBlock;
import com.alc.moreminecarts.containers.TankCartContainer;
import com.alc.moreminecarts.entities.FlagCartEntity;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.network.NetworkHooks;

public class TankCartEntity
extends AbstractMinecartEntity
implements INamedContainerProvider {
    private static final DataParameter<CompoundNBT> FLUID_TAG = EntityDataManager.func_187226_a(FlagCartEntity.class, (IDataSerializer)DataSerializers.field_192734_n);
    boolean changed_flag;
    public final IIntArray dataAccess = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return TankCartEntity.this.func_145782_y();
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int set_to) {
        }

        public int func_221478_a() {
            return 1;
        }
    };
    LazyOptional<IFluidHandler> fluid_handler = LazyOptional.of(() -> new CartTank(40000));

    public TankCartEntity(EntityType<?> type, World world) {
        super(type, world);
    }

    public TankCartEntity(EntityType<?> type, World worldIn, double x, double y, double z) {
        super(type, worldIn, x, y, z);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluid_handler.cast();
        }
        return super.getCapability(cap);
    }

    public AbstractMinecartEntity.Type func_184264_v() {
        return AbstractMinecartEntity.Type.CHEST;
    }

    public void func_94095_a(DamageSource source) {
        super.func_94095_a(source);
        if (!source.func_94541_c() && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            this.func_199703_a((IItemProvider)MMItemReferences.transport_tank);
        }
    }

    public BlockState func_180457_u() {
        return (BlockState)MMReferences.piston_display_block.func_176223_P().func_206870_a((Property)PistonDisplayBlock.VARIANT, (Comparable)Integer.valueOf(4));
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean stillValid(PlayerEntity player) {
        return player.func_70092_e(this.func_213303_ch().field_72450_a + 0.5, this.func_213303_ch().field_72448_b + 0.5, this.func_213303_ch().field_72449_c + 0.5) <= 64.0;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FLUID_TAG, (Object)new CompoundNBT());
    }

    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        ((FluidTank)this.fluid_handler.orElse(null)).writeToNBT(compound);
    }

    protected void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        FluidTank tank = (FluidTank)this.fluid_handler.resolve().get();
        tank.setFluid(tank.readFromNBT(compound).getFluid());
        this.changed_flag = true;
    }

    public FluidStack getFluidStack() {
        if (!this.field_70170_p.field_72995_K) {
            return ((IFluidHandler)this.fluid_handler.orElse(null)).getFluidInTank(0);
        }
        return ((FluidTank)this.fluid_handler.orElse(null)).readFromNBT((CompoundNBT)this.field_70180_af.func_187225_a(FLUID_TAG)).getFluid();
    }

    public int getComparatorSignal() {
        return (int)Math.floor((double)((float)((FluidTank)this.fluid_handler.resolve().get()).getFluidAmount() / (float)((FluidTank)this.fluid_handler.resolve().get()).getCapacity()) * 15.0);
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory inv, PlayerEntity player) {
        return new TankCartContainer(i, this.field_70170_p, this, inv, player);
    }

    public ActionResultType func_184230_a(PlayerEntity p_184230_1_, Hand p_184230_2_) {
        ActionResultType ret = super.func_184230_a(p_184230_1_, p_184230_2_);
        if (ret.func_226246_a_()) {
            return ret;
        }
        p_184230_1_.func_213829_a((INamedContainerProvider)this);
        return ActionResultType.SUCCESS;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.changed_flag && !this.field_70170_p.field_72995_K) {
            this.updateSynchedData();
            this.changed_flag = false;
        }
    }

    protected void updateSynchedData() {
        CompoundNBT compound = new CompoundNBT();
        ((FluidTank)this.fluid_handler.orElse(null)).writeToNBT(compound);
        this.field_70180_af.func_187227_b(FLUID_TAG, (Object)compound);
    }

    public ItemStack getCartItem() {
        return new ItemStack((IItemProvider)MMItemReferences.tank_cart);
    }

    public class CartTank
    extends FluidTank {
        public CartTank(int capacity) {
            super(capacity);
        }

        protected void onContentsChanged() {
            super.onContentsChanged();
            if (TankCartEntity.this.field_70170_p != null && !TankCartEntity.this.field_70170_p.field_72995_K) {
                TankCartEntity.this.updateSynchedData();
            }
        }
    }
}

