/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.entities;

import com.alc.moreminecarts.MMItemReferences;
import com.alc.moreminecarts.proxy.MoreMinecartsPacketHandler;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CouplerEntity
extends Entity {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String COUPLED_COMPOUND = "Couples";
    private static final String TAG_COUPLED_UUID_1 = "coupled_UUID_1";
    private static final String TAG_COUPLED_UUID_2 = "coupled_UUID_2";
    private static final double PREFERRED_DISTANCE = 2.0;
    private CompoundNBT vehicleNBTTag;
    public Entity vehicle1;
    public int vehicle1_id;
    public Entity vehicle2;
    public int vehicle2_id;
    public double lastForceX = 0.0;
    public double lastForceY = 0.0;
    public double lastForceZ = 0.0;
    public double lastDiff = 0.0;

    public CouplerEntity(EntityType<?> type, World worldIn, Entity vehicle1, Entity vehicle2) {
        super(type, worldIn);
        this.vehicle1 = vehicle1;
        this.vehicle1_id = vehicle1.func_145782_y();
        this.vehicle2 = vehicle2;
        this.vehicle2_id = vehicle2.func_145782_y();
        this.updateDisplay();
    }

    public CouplerEntity(EntityType<CouplerEntity> type, World world) {
        super(type, world);
    }

    protected void func_70088_a() {
    }

    @Nullable
    public Entity getFirstVehicle() {
        if (this.vehicle1 == null && this.vehicle1_id != 0 && this.field_70170_p.field_72995_K) {
            this.vehicle1 = this.field_70170_p.func_73045_a(this.vehicle1_id);
        }
        return this.vehicle1;
    }

    @Nullable
    public Entity getSecondVehicle() {
        if (this.vehicle2 == null && this.vehicle2_id != 0 && this.field_70170_p.field_72995_K) {
            this.vehicle2 = this.field_70170_p.func_73045_a(this.vehicle2_id);
        }
        return this.vehicle2;
    }

    public void func_70071_h_() {
        double distance;
        if (this.field_70170_p.field_72995_K) {
            this.updateDisplay();
            return;
        }
        if (this.vehicle1 == null || this.vehicle2 == null) {
            this.recreateCouple();
            return;
        }
        if (!this.vehicle1.func_70089_S() || !this.vehicle2.func_70089_S()) {
            if (this.vehicle1.func_70089_S()) {
                this.releaseTensionToOne(true);
            }
            if (this.vehicle2.func_70089_S()) {
                this.releaseTensionToOne(false);
            }
            this.onBroken(true);
        }
        if ((distance = (double)this.vehicle1.func_70032_d(this.vehicle2)) > 6.0) {
            this.onBroken(true);
        } else {
            double distance_diff;
            Vector3d motion1 = this.vehicle1.func_213322_ci();
            Vector3d motion2 = this.vehicle2.func_213322_ci();
            this.lastDiff = distance_diff = distance - 2.0;
            Vector3d between = this.vehicle1.func_213303_ch().func_178788_d(this.vehicle2.func_213303_ch());
            this.lastForceX = between.field_72450_a;
            this.lastForceY = between.field_72448_b;
            this.lastForceZ = between.field_72449_c;
            Vector3d force = between.func_72432_b().func_186678_a(CouplerEntity.getSpringForce(distance_diff));
            this.vehicle1.func_213317_d(motion1.func_178787_e(force.func_186678_a(-1.0 * CouplerEntity.getEntityForceScale(this.vehicle1))));
            this.vehicle2.func_213317_d(motion2.func_178787_e(force.func_186678_a(1.0 * CouplerEntity.getEntityForceScale(this.vehicle2))));
            this.vehicle1.func_213317_d(this.vehicle1.func_213322_ci().func_186678_a(0.95));
            this.vehicle2.func_213317_d(this.vehicle2.func_213322_ci().func_186678_a(0.95));
        }
        super.func_70071_h_();
        this.updateDisplay();
    }

    public boolean func_241845_aY() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_241849_j(Entity p_241849_1_) {
        return false;
    }

    public PushReaction func_184192_z() {
        return PushReaction.IGNORE;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public static double getEntityForceScale(Entity ent) {
        if (ent instanceof AbstractMinecartEntity && ((AbstractMinecartEntity)ent).func_184264_v() == AbstractMinecartEntity.Type.FURNACE) {
            return 0.1;
        }
        return 1.0;
    }

    public static double getSpringForce(double distance) {
        boolean is_neg = distance < 0.0;
        double unsigned = Math.abs(Math.pow(Math.abs(distance), 3.0) * 0.3);
        return is_neg ? -1.0 * unsigned : unsigned;
    }

    public static double getIntegratedSpringForce(double distance) {
        boolean is_neg = distance < 0.0;
        double unsigned = Math.abs(0.3333333333333333 * Math.pow(Math.abs(distance), 4.0) * 0.3);
        return is_neg ? -1.0 * unsigned : unsigned;
    }

    private void recreateCouple() {
        if (this.vehicleNBTTag == null) {
            return;
        }
        if (this.field_70170_p instanceof ServerWorld) {
            UUID uuid;
            Entity entity;
            if (this.vehicleNBTTag.func_186855_b(TAG_COUPLED_UUID_1) && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(uuid = this.vehicleNBTTag.func_186857_a(TAG_COUPLED_UUID_1))) != null) {
                this.vehicle1 = entity;
                this.vehicle1_id = this.vehicle1.func_145782_y();
            }
            if (this.vehicleNBTTag.func_186855_b(TAG_COUPLED_UUID_2) && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(uuid = this.vehicleNBTTag.func_186857_a(TAG_COUPLED_UUID_2))) != null) {
                this.vehicle2 = entity;
                this.vehicle2_id = this.vehicle2.func_145782_y();
            }
            if (this.vehicle1 != null && this.vehicle2 != null) {
                MoreMinecartsPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new MoreMinecartsPacketHandler.CouplePacket(this.func_145782_y(), this.vehicle1_id, this.vehicle2_id));
            }
            if (this.field_70173_aa > 100) {
                this.onBroken(true);
                this.vehicleNBTTag = null;
            }
        }
    }

    private void releaseTensionToOne(boolean is_first) {
        Entity to = is_first ? this.vehicle1 : this.vehicle2;
        int scalar = is_first ? 1 : -1;
        Vector3d motion = to.func_213322_ci();
        Vector3d between = new Vector3d(this.lastForceX, this.lastForceY, this.lastForceZ);
        Vector3d force = between.func_72432_b().func_186678_a(CouplerEntity.getIntegratedSpringForce(this.lastDiff));
        to.func_213317_d(motion.func_178787_e(force.func_186678_a((double)scalar)));
    }

    private void releaseTensionToBoth() {
        Vector3d motion1 = this.vehicle1.func_213322_ci();
        Vector3d motion2 = this.vehicle2.func_213322_ci();
        Vector3d between = new Vector3d(this.lastForceX, this.lastForceY, this.lastForceZ);
        Vector3d force = between.func_72432_b().func_186678_a(CouplerEntity.getIntegratedSpringForce(this.lastDiff));
        this.vehicle1.func_213317_d(motion1.func_178787_e(force.func_186678_a(0.5)));
        this.vehicle2.func_213317_d(motion2.func_178787_e(force.func_186678_a(-0.5)));
    }

    public boolean func_85031_j(Entity player) {
        if (player instanceof PlayerEntity) {
            PlayerEntity playerentity = (PlayerEntity)player;
            return !this.field_70170_p.func_175660_a(playerentity, this.func_226268_ag_()) ? true : this.func_70097_a(DamageSource.func_76365_a((PlayerEntity)playerentity), 0.0f);
        }
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.func_70089_S() && !this.field_70170_p.field_72995_K) {
            this.releaseTensionToBoth();
            this.onBroken(!source.func_180136_u());
            this.func_70018_K();
        }
        return true;
    }

    public void onBroken(boolean drop_item) {
        this.func_184185_a(SoundEvents.field_232697_bz_, 1.0f, 1.0f);
        if (drop_item) {
            this.func_199703_a((IItemProvider)MMItemReferences.coupler);
        }
        this.func_70106_y();
    }

    public void func_70037_a(CompoundNBT compound) {
        if (compound.func_150297_b(COUPLED_COMPOUND, 10)) {
            this.vehicleNBTTag = compound.func_74775_l(COUPLED_COMPOUND);
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        if (this.vehicle1 != null && this.vehicle2 != null) {
            CompoundNBT new_compound = new CompoundNBT();
            new_compound.func_186854_a(TAG_COUPLED_UUID_1, this.vehicle1.func_110124_au());
            new_compound.func_186854_a(TAG_COUPLED_UUID_2, this.vehicle2.func_110124_au());
            compound.func_218657_a(COUPLED_COMPOUND, (INBT)new_compound);
        } else if (this.vehicleNBTTag != null) {
            compound.func_218657_a(COUPLED_COMPOUND, (INBT)this.vehicleNBTTag.func_74737_b());
        }
    }

    protected void updateDisplay() {
        Entity ent1 = this.getFirstVehicle();
        Entity ent2 = this.getSecondVehicle();
        if (ent1 == null || ent2 == null) {
            return;
        }
        Vector3d v1 = ent1.func_213303_ch();
        Vector3d v2 = ent2.func_213303_ch();
        double x = (v1.field_72450_a + v2.field_72450_a) / 2.0;
        double y = (v1.field_72448_b + v2.field_72448_b) / 2.0;
        double z = (v1.field_72449_c + v2.field_72449_c) / 2.0;
        this.func_70107_b(x, y, z);
    }

    public IPacket<?> func_213297_N() {
        IPacket packet = NetworkHooks.getEntitySpawningPacket((Entity)this);
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        try {
            packet.func_148840_b(buf);
        }
        catch (IOException e) {
            LOGGER.info("UNABLE TO WRITE TO BUFFER!");
        }
        buf.writeInt(this.vehicle1_id);
        buf.writeInt(this.vehicle2_id);
        try {
            packet.func_148837_a(buf);
        }
        catch (IOException e) {
            LOGGER.info("UNABLE TO READ FROM BUFFER!");
        }
        return packet;
    }
}

