/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.entities;

import com.alc.moreminecarts.MMItemReferences;
import com.alc.moreminecarts.MMReferences;
import com.alc.moreminecarts.blocks.containers.ChunkLoaderBlock;
import com.alc.moreminecarts.containers.ChunkLoaderContainer;
import com.alc.moreminecarts.tile_entities.ChunkLoaderTile;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.item.minecart.ContainerMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.state.Property;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.fml.network.NetworkHooks;

public class ChunkLoaderCartEntity
extends ContainerMinecartEntity {
    private static final DataParameter<Boolean> POWERED = EntityDataManager.func_187226_a(ChunkLoaderCartEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public final IIntArray dataAccess = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return (int)Math.ceil((double)(Math.abs(ChunkLoaderCartEntity.this.time_left) - 1) / 1200.0) * this.func_221476_a(1);
                }
                case 1: {
                    return ChunkLoaderCartEntity.this.time_left > 0 ? 1 : -1;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int set_to) {
            switch (index) {
                case 0: {
                    ChunkLoaderCartEntity.this.time_left = set_to * 1200;
                    break;
                }
                case 1: {
                    ChunkLoaderCartEntity.this.time_left = Math.abs(ChunkLoaderCartEntity.this.time_left) * (set_to > 0 ? 1 : -1);
                    break;
                }
            }
        }

        public int func_221478_a() {
            return 2;
        }
    };
    public boolean lit_last_tick = false;
    public int time_left = -1;
    public int last_chunk_x = this.func_226268_ag_().func_177958_n() >> 4;
    public int last_chunk_z = this.func_226268_ag_().func_177952_p() >> 4;

    public ChunkLoaderCartEntity(EntityType<?> type, World world) {
        super(type, world);
    }

    public ChunkLoaderCartEntity(EntityType<?> type, World worldIn, double x, double y, double z) {
        super(type, x, y, z, worldIn);
    }

    public AbstractMinecartEntity.Type func_184264_v() {
        return AbstractMinecartEntity.Type.CHEST;
    }

    public void func_94095_a(DamageSource source) {
        super.func_94095_a(source);
        if (!source.func_94541_c() && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            this.func_199703_a((IItemProvider)MMItemReferences.chunk_loader);
            ChunkLoaderTile.dropExtras(this.field_70170_p, this.time_left, this.func_226268_ag_());
        }
        this.onRemoval();
    }

    public void remove(boolean keepData) {
        super.remove(keepData);
        this.onRemoval();
    }

    protected Container func_213968_a(int i, PlayerInventory inv) {
        return new ChunkLoaderContainer(i, this.field_70170_p, (IInventory)this, this.dataAccess, inv, inv.field_70458_d);
    }

    protected boolean isMinecartPowered() {
        return (Boolean)this.field_70180_af.func_187225_a(POWERED);
    }

    protected void setMinecartPowered(boolean powered) {
        this.field_70180_af.func_187227_b(POWERED, (Object)powered);
    }

    public BlockState func_180457_u() {
        return (BlockState)MMReferences.chunk_loader.func_176223_P().func_206870_a((Property)ChunkLoaderBlock.POWERED, (Comparable)Boolean.valueOf(this.isMinecartPowered()));
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_96095_a(int p_96095_1_, int p_96095_2_, int p_96095_3_, boolean p_96095_4_) {
        this.setEnabled(p_96095_4_);
    }

    public int func_70302_i_() {
        return 1;
    }

    public boolean func_70300_a(PlayerEntity player) {
        return player.func_70092_e(this.func_213303_ch().field_72450_a + 0.5, this.func_213303_ch().field_72448_b + 0.5, this.func_213303_ch().field_72449_c + 0.5) <= 64.0;
    }

    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a(ChunkLoaderTile.TIME_LEFT_PROPERTY, this.time_left);
        compound.func_74768_a(ChunkLoaderTile.LAST_CHUNK_X_PROPERTY, this.last_chunk_x);
        compound.func_74768_a(ChunkLoaderTile.LAST_CHUNK_Z_PROPERTY, this.last_chunk_z);
    }

    protected void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.time_left = compound.func_74762_e(ChunkLoaderTile.TIME_LEFT_PROPERTY);
        this.last_chunk_x = compound.func_74762_e(ChunkLoaderTile.LAST_CHUNK_X_PROPERTY);
        this.last_chunk_z = compound.func_74762_e(ChunkLoaderTile.LAST_CHUNK_Z_PROPERTY);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(POWERED, (Object)false);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        boolean changed_flag = false;
        if (this.isLit()) {
            --this.time_left;
        }
        if (!this.field_70170_p.func_201670_d()) {
            int burn_duration = ChunkLoaderTile.getBurnDuration(((ItemStack)this.field_94113_a.get(0)).func_77973_b());
            if (burn_duration >= 0 && Math.abs(this.time_left) + burn_duration <= ChunkLoaderTile.MAX_TIME) {
                changed_flag = true;
                this.time_left = this.time_left > 0 ? (this.time_left += burn_duration) : (this.time_left -= burn_duration);
                ((ItemStack)this.field_94113_a.get(0)).func_190918_g(1);
            }
            int chunk_x = this.func_226268_ag_().func_177958_n() >> 4;
            int chunk_z = this.func_226268_ag_().func_177952_p() >> 4;
            if (chunk_x != this.last_chunk_x || chunk_z != this.last_chunk_z) {
                changed_flag = true;
                this.forceChucksAt(this.last_chunk_x, this.last_chunk_z, false);
                this.last_chunk_x = chunk_x;
                this.last_chunk_z = chunk_z;
                boolean bl = this.lit_last_tick = !this.isLit();
            }
            if (this.lit_last_tick != this.isLit()) {
                changed_flag = true;
                if (this.isLit()) {
                    this.forceChucksAt(chunk_x, chunk_z, true);
                } else {
                    this.forceChucksAt(chunk_x, chunk_z, false);
                }
                this.setMinecartPowered(this.isLit());
            }
            if (changed_flag) {
                this.func_70296_d();
            }
        }
        this.lit_last_tick = this.isLit();
    }

    private void forceChucksAt(int chunk_x, int chunk_z, boolean add) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                ForgeChunkManager.forceChunk((ServerWorld)((ServerWorld)this.field_70170_p), (String)"moreminecarts", (Entity)this, (int)(chunk_x + i), (int)(chunk_z + j), (boolean)add, (boolean)true);
            }
        }
    }

    public void onRemoval() {
        if (!this.field_70170_p.field_72995_K) {
            int chunk_x = this.func_226268_ag_().func_177958_n() >> 4;
            int chunk_z = this.func_226268_ag_().func_177952_p() >> 4;
            this.forceChucksAt(chunk_x, chunk_z, false);
        }
    }

    public boolean isLit() {
        return this.time_left > 1 && this.isEnabled();
    }

    public boolean isEnabled() {
        return this.time_left > 0;
    }

    public void setEnabled(boolean enabled) {
        this.time_left = Math.abs(this.time_left) * (enabled ? 1 : -1);
    }

    public int getComparatorSignal() {
        float true_time_left = Math.abs(this.time_left) - 1;
        double log_proportion = Math.log10(true_time_left / (float)ChunkLoaderTile.MAX_TIME * 9.0f + 1.0f);
        return (int)Math.ceil(log_proportion * 15.0);
    }

    public ItemStack getCartItem() {
        return new ItemStack((IItemProvider)MMItemReferences.chunk_loader_cart);
    }
}

