/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.entities;

import com.alc.moreminecarts.MMItemReferences;
import com.alc.moreminecarts.MMReferences;
import com.alc.moreminecarts.blocks.PistonDisplayBlock;
import com.alc.moreminecarts.containers.BatteryCartContainer;
import com.alc.moreminecarts.entities.FlagCartEntity;
import com.alc.moreminecarts.misc.SettableEnergyStorage;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.network.NetworkHooks;

public class BatteryCartEntity
extends AbstractMinecartEntity
implements INamedContainerProvider {
    public static String ENERGY_PROPERTY = "energy";
    private static final DataParameter<Integer> ENERGY_AMOUNT = EntityDataManager.func_187226_a(FlagCartEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public final IIntArray dataAccess = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return BatteryCartEntity.this.func_145782_y();
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int set_to) {
        }

        public int func_221478_a() {
            return 1;
        }
    };
    LazyOptional<IEnergyStorage> energy_handler = LazyOptional.of(() -> new CartBattery(40000));

    public BatteryCartEntity(EntityType<?> type, World world) {
        super(type, world);
    }

    public BatteryCartEntity(EntityType<?> type, World worldIn, double x, double y, double z) {
        super(type, worldIn, x, y, z);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energy_handler.cast();
        }
        return super.getCapability(cap);
    }

    public AbstractMinecartEntity.Type func_184264_v() {
        return AbstractMinecartEntity.Type.CHEST;
    }

    public void func_94095_a(DamageSource source) {
        super.func_94095_a(source);
        if (!source.func_94541_c() && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            this.func_199703_a((IItemProvider)MMItemReferences.transport_battery);
        }
    }

    public BlockState func_180457_u() {
        return (BlockState)MMReferences.piston_display_block.func_176223_P().func_206870_a((Property)PistonDisplayBlock.VARIANT, (Comparable)Integer.valueOf(5));
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean stillValid(PlayerEntity player) {
        return player.func_70092_e(this.func_213303_ch().field_72450_a + 0.5, this.func_213303_ch().field_72448_b + 0.5, this.func_213303_ch().field_72449_c + 0.5) <= 64.0;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ENERGY_AMOUNT, (Object)0);
    }

    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a(ENERGY_PROPERTY, ((IEnergyStorage)this.energy_handler.orElse(null)).getEnergyStored());
    }

    protected void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        ((IEnergyStorage)this.energy_handler.orElse(null)).receiveEnergy(compound.func_74762_e(ENERGY_PROPERTY), false);
    }

    public int getEnergyAmount() {
        return (Integer)this.field_70180_af.func_187225_a(ENERGY_AMOUNT);
    }

    public int getComparatorSignal() {
        return (int)Math.floor((double)((float)((IEnergyStorage)this.energy_handler.resolve().get()).getEnergyStored() / (float)((IEnergyStorage)this.energy_handler.resolve().get()).getMaxEnergyStored()) * 15.0);
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory inv, PlayerEntity player) {
        return new BatteryCartContainer(i, this.field_70170_p, this, inv, player);
    }

    public ActionResultType func_184230_a(PlayerEntity p_184230_1_, Hand p_184230_2_) {
        ActionResultType ret = super.func_184230_a(p_184230_1_, p_184230_2_);
        if (ret.func_226246_a_()) {
            return ret;
        }
        p_184230_1_.func_213829_a((INamedContainerProvider)this);
        return ActionResultType.SUCCESS;
    }

    public ItemStack getCartItem() {
        return new ItemStack((IItemProvider)MMItemReferences.battery_cart);
    }

    public class CartBattery
    extends SettableEnergyStorage {
        public CartBattery(int capacity) {
            super(capacity);
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int ret = super.receiveEnergy(maxReceive, simulate);
            if (!simulate && BatteryCartEntity.this.field_70170_p != null) {
                BatteryCartEntity.this.field_70180_af.func_187227_b(ENERGY_AMOUNT, (Object)this.energy);
            }
            return ret;
        }

        public int extractEnergy(int maxReceive, boolean simulate) {
            int ret = super.extractEnergy(maxReceive, simulate);
            if (!simulate && BatteryCartEntity.this.field_70170_p != null) {
                BatteryCartEntity.this.field_70180_af.func_187227_b(ENERGY_AMOUNT, (Object)this.energy);
            }
            return ret;
        }
    }
}

