/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.blocks.utility_rails;

import com.alc.moreminecarts.entities.PistonPushcartEntity;
import com.alc.moreminecarts.entities.StickyPistonPushcartEntity;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RailShape;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class PistonLifterRailBlock
extends AbstractRailBlock {
    public static final EnumProperty<RailShape> SHAPE = BlockStateProperties.field_208166_S;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public static final EnumProperty EFFECT = EnumProperty.func_177706_a((String)"effect", PistonLifterEffect.class, (Enum[])new PistonLifterEffect[]{PistonLifterEffect.lift, PistonLifterEffect.delift, PistonLifterEffect.snap});

    public PistonLifterRailBlock(AbstractBlock.Properties builder) {
        super(true, builder);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a(SHAPE, (Comparable)RailShape.NORTH_SOUTH)).func_206870_a((Property)EFFECT, (Comparable)((Object)PistonLifterEffect.lift)));
    }

    public boolean canMakeSlopes(BlockState state, IBlockReader world, BlockPos pos) {
        return false;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (worldIn.func_201670_d() || !((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) {
            return;
        }
        this.checkPressed(worldIn, pos, state);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        this.checkPressed((World)worldIn, pos, state);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{SHAPE, POWERED, EFFECT});
    }

    private void checkPressed(World worldIn, BlockPos pos, BlockState state) {
        if (this.func_196260_a(state, (IWorldReader)worldIn, pos)) {
            List<AbstractMinecartEntity> list = this.findMinecarts(worldIn, pos, AbstractMinecartEntity.class, entity -> true);
            for (AbstractMinecartEntity minecart : list) {
                if (state.func_177229_b((Property)EFFECT) == PistonLifterEffect.snap) {
                    if (!(minecart instanceof StickyPistonPushcartEntity)) continue;
                    ((StickyPistonPushcartEntity)minecart).attempt_contract();
                    continue;
                }
                if (!(minecart instanceof PistonPushcartEntity)) continue;
                ((PistonPushcartEntity)minecart).attemptMove(state.func_177229_b((Property)EFFECT) == PistonLifterEffect.lift, true);
            }
        }
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.func_203425_a(state.func_177230_c())) {
            this.checkPressed(worldIn, pos, this.func_235327_a_(state, worldIn, pos, isMoving));
        }
    }

    protected <T extends AbstractMinecartEntity> List<T> findMinecarts(World worldIn, BlockPos pos, Class<T> cartType, @Nullable Predicate<Entity> filter) {
        return worldIn.func_175647_a(cartType, this.getDectectionBox(pos), filter);
    }

    private AxisAlignedBB getDectectionBox(BlockPos pos) {
        double d0 = 0.2;
        return new AxisAlignedBB((double)pos.func_177958_n() + 0.2, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.2, (double)(pos.func_177958_n() + 1) - 0.2, (double)(pos.func_177956_o() + 1) - 0.2, (double)(pos.func_177952_p() + 1) - 0.2);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.func_201670_d()) {
            PistonLifterEffect effect = (PistonLifterEffect)((Object)state.func_177229_b((Property)EFFECT));
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)EFFECT, (Comparable)((Object)effect.next())));
            worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        return ActionResultType.func_233537_a_((boolean)worldIn.func_201670_d());
    }

    protected void func_189541_b(BlockState state, World worldIn, BlockPos pos, Block blockIn) {
        boolean flag2;
        boolean flag1 = (Boolean)state.func_177229_b((Property)POWERED);
        if (flag1 != (flag2 = worldIn.func_175640_z(pos))) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(flag2)), 3);
            worldIn.func_195593_d(pos.func_177977_b(), (Block)this);
        }
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                switch ((RailShape)state.func_177229_b(SHAPE)) {
                    case ASCENDING_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_EAST);
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.NORTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.NORTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.SOUTH_WEST);
                    }
                }
            }
            case COUNTERCLOCKWISE_90: {
                switch ((RailShape)state.func_177229_b(SHAPE)) {
                    case ASCENDING_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_EAST);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.NORTH_WEST);
                    }
                    case NORTH_SOUTH: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.NORTH_SOUTH);
                    }
                }
            }
            case CLOCKWISE_90: {
                switch ((RailShape)state.func_177229_b(SHAPE)) {
                    case ASCENDING_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_EAST);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.NORTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_SOUTH: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.NORTH_SOUTH);
                    }
                }
            }
        }
        return state;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        RailShape railshape = (RailShape)state.func_177229_b(SHAPE);
        block0 : switch (mirrorIn) {
            case LEFT_RIGHT: {
                switch (railshape) {
                    case ASCENDING_NORTH: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.SOUTH_EAST);
                    }
                }
                return super.func_185471_a(state, mirrorIn);
            }
            case FRONT_BACK: {
                switch (railshape) {
                    case ASCENDING_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_EAST);
                    }
                    default: {
                        break block0;
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.NORTH_EAST);
                    }
                    case NORTH_EAST: 
                }
                return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.NORTH_WEST);
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    public Property<RailShape> func_176560_l() {
        return SHAPE;
    }

    public static enum PistonLifterEffect implements IStringSerializable
    {
        lift,
        delift,
        snap;


        public String func_176610_l() {
            switch (this) {
                case lift: {
                    return "lift";
                }
                case delift: {
                    return "delift";
                }
                case snap: {
                    return "snap";
                }
            }
            return "ERROR";
        }

        public PistonLifterEffect next() {
            switch (this) {
                case lift: {
                    return delift;
                }
                case delift: {
                    return snap;
                }
                case snap: {
                    return lift;
                }
            }
            return lift;
        }
    }
}

