/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.blocks.utility_rails;

import com.alc.moreminecarts.tile_entities.LockingRailTile;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class LockingRailBlock
extends AbstractRailBlock
implements ITileEntityProvider {
    public static final EnumProperty<RailShape> SHAPE = BlockStateProperties.field_208166_S;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public static final BooleanProperty INVERTED = BooleanProperty.func_177716_a((String)"inverted");

    public LockingRailBlock(AbstractBlock.Properties builder) {
        super(true, builder);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a(SHAPE, (Comparable)RailShape.NORTH_SOUTH)).func_206870_a((Property)INVERTED, (Comparable)Boolean.valueOf(true)));
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        super.func_225534_a_(state, world, pos, rand);
        this.updateTileEntity(state, (World)world, pos);
    }

    protected void func_189541_b(BlockState state, World worldIn, BlockPos pos, Block blockIn) {
        boolean new_powered;
        boolean old_powered = (Boolean)state.func_177229_b((Property)POWERED);
        if (old_powered != (new_powered = worldIn.func_175640_z(pos))) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(new_powered)), 3);
            this.updateTileEntity(state, worldIn, pos);
            worldIn.func_195593_d(pos.func_177977_b(), (Block)this);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.func_201670_d()) {
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)INVERTED, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((Property)INVERTED) == false)));
            worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        return ActionResultType.func_233537_a_((boolean)worldIn.func_201670_d());
    }

    public boolean canMakeSlopes(BlockState state, IBlockReader world, BlockPos pos) {
        return false;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        AbstractMinecartEntity locked_minecart;
        if (worldIn.func_201670_d()) {
            return;
        }
        if (entityIn instanceof AbstractMinecartEntity && entityIn == (locked_minecart = this.updateTileEntity(state, worldIn, pos))) {
            locked_minecart.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            locked_minecart.func_213293_j(0.0, 0.0, 0.0);
        }
    }

    private AbstractMinecartEntity updateTileEntity(BlockState state, World worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof LockingRailTile) {
            boolean update_signal = ((LockingRailTile)te).updateLock((Boolean)state.func_177229_b((Property)POWERED) ^ (Boolean)state.func_177229_b((Property)INVERTED));
            if (update_signal) {
                worldIn.func_175666_e(pos, state.func_177230_c());
            }
            return ((LockingRailTile)te).locked_minecart;
        }
        return null;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{SHAPE, POWERED, INVERTED});
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.func_203425_a(state.func_177230_c())) {
            this.func_189541_b(state, worldIn, pos, state.func_177230_c());
            this.updateTileEntity(state, worldIn, pos);
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader reader) {
        return new LockingRailTile();
    }

    public boolean func_149740_M(BlockState p_149740_1_) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof LockingRailTile) {
            return ((LockingRailTile)te).getComparatorSignal();
        }
        return 0;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                switch ((RailShape)state.func_177229_b(SHAPE)) {
                    case ASCENDING_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_EAST);
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.NORTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.NORTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.SOUTH_WEST);
                    }
                }
            }
            case COUNTERCLOCKWISE_90: {
                switch ((RailShape)state.func_177229_b(SHAPE)) {
                    case ASCENDING_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_EAST);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.NORTH_WEST);
                    }
                    case NORTH_SOUTH: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.NORTH_SOUTH);
                    }
                }
            }
            case CLOCKWISE_90: {
                switch ((RailShape)state.func_177229_b(SHAPE)) {
                    case ASCENDING_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_EAST);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.NORTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_SOUTH: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.NORTH_SOUTH);
                    }
                }
            }
        }
        return state;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        RailShape railshape = (RailShape)state.func_177229_b(SHAPE);
        block0 : switch (mirrorIn) {
            case LEFT_RIGHT: {
                switch (railshape) {
                    case ASCENDING_NORTH: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.SOUTH_EAST);
                    }
                }
                return super.func_185471_a(state, mirrorIn);
            }
            case FRONT_BACK: {
                switch (railshape) {
                    case ASCENDING_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_EAST);
                    }
                    default: {
                        break block0;
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.NORTH_EAST);
                    }
                    case NORTH_EAST: 
                }
                return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.NORTH_WEST);
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    public Property<RailShape> func_176560_l() {
        return SHAPE;
    }
}

