/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.tile;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mob_grinding_utils.MobGrindingUtils;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.ModItems;
import mob_grinding_utils.inventory.server.ContainerMGUSpawner;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityMGUSpawner
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    public int spawning_progress = 0;
    public int MAX_SPAWNING_TIME = 100;
    public boolean isOn = false;
    public ItemStackHandler inputSlots = new ItemStackHandler(4);
    public ItemStackHandler fuelSlot = new ItemStackHandler(1){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.func_77973_b() == ModItems.SOLID_XP_BABY.get();
        }
    };
    private final LazyOptional<IItemHandler> fuelSlotCap = LazyOptional.of(() -> this.fuelSlot);
    public int animationTicks;
    public int prevAnimationTicks;
    public boolean showRenderBox;
    public int offsetX;
    public int offsetY;
    public int offsetZ;

    public TileEntityMGUSpawner() {
        super(ModBlocks.ENTITY_SPAWNER.getTileEntityType());
    }

    public void toggleOnOff() {
        this.isOn = !this.isOn;
    }

    public void func_73660_a() {
        if (this.isOn) {
            if (this.func_145831_w().field_72995_K) {
                this.prevAnimationTicks = this.animationTicks;
                if (this.animationTicks < 360) {
                    this.animationTicks += 9;
                }
                if (this.animationTicks >= 360) {
                    this.animationTicks -= 360;
                    this.prevAnimationTicks -= 360;
                }
            }
            if (!this.func_145831_w().field_72995_K) {
                if (this.canOperate()) {
                    this.setProgress(this.getProgress() + 1 + this.getSpeedModifierAmount());
                    if (this.getProgress() >= this.MAX_SPAWNING_TIME) {
                        if (this.spawnMobInArea()) {
                            this.fuelSlot.getStackInSlot(0).func_190918_g(1);
                        }
                        this.setProgress(0);
                        return;
                    }
                } else if (this.getProgress() > 0) {
                    this.setProgress(0);
                }
            }
        } else {
            if (this.func_145831_w().field_72995_K) {
                this.animationTicks = 0;
                this.prevAnimationTicks = 0;
            }
            if (!this.func_145831_w().field_72995_K && this.getProgress() > 0) {
                this.setProgress(0);
            }
        }
    }

    private boolean spawnMobInArea() {
        EntityType type = null;
        ItemStack eggStack = this.inputSlots.getStackInSlot(0);
        SpawnEggItem eggItem = (SpawnEggItem)eggStack.func_77973_b();
        type = eggItem.func_208076_b(null);
        if (type != null && !type.func_220341_a(MobGrindingUtils.NOSPAWN) && !type.func_220341_a(MobGrindingUtils.NOSWAB)) {
            AxisAlignedBB axisalignedbb = this.getAABBWithModifiers();
            int minX = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
            int maxX = MathHelper.func_76128_c((double)axisalignedbb.field_72336_d);
            int minY = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
            int maxY = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
            int minZ = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
            int maxZ = MathHelper.func_76128_c((double)axisalignedbb.field_72334_f);
            BlockPos.Mutable mutablePos = new BlockPos.Mutable();
            MobEntity entity = (MobEntity)type.func_200721_a(this.func_145831_w());
            ArrayList<BlockPos> posArrayList = new ArrayList<BlockPos>();
            if (entity != null) {
                for (int x = minX; x < maxX; ++x) {
                    for (int y = minY; y < maxY; ++y) {
                        for (int z = minZ; z < maxZ; ++z) {
                            BlockPos posList = new BlockPos(x, y, z);
                            entity.func_70107_b((double)posList.func_177958_n() + 0.5, (double)posList.func_177956_o(), (double)posList.func_177952_p() + 0.5);
                            if (!this.isValidSpawnLocation(this.func_145831_w(), type, (Entity)entity, posList)) continue;
                            posArrayList.add(posList);
                        }
                    }
                }
                if (!posArrayList.isEmpty()) {
                    Collections.shuffle(posArrayList);
                    entity.func_70107_b((double)((BlockPos)posArrayList.get(0)).func_177958_n() + 0.5, (double)((BlockPos)posArrayList.get(0)).func_177956_o(), (double)((BlockPos)posArrayList.get(0)).func_177952_p() + 0.5);
                    entity.func_213386_a((IServerWorld)this.func_145831_w(), this.func_145831_w().func_175649_E((BlockPos)posArrayList.get(0)), SpawnReason.NATURAL, null, null);
                    this.func_145831_w().func_217376_c((Entity)entity);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isValidSpawnLocation(World world, EntityType<?> type, Entity entity, BlockPos pos) {
        return WorldEntitySpawner.func_209382_a((EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.func_209344_a(type), (IWorldReader)world, (BlockPos)pos, type) && world.func_217394_a(entity.func_200600_R(), entity.func_174813_aQ(), EntityPredicates.field_94557_a).isEmpty() && this.func_145831_w().func_226669_j_(entity);
    }

    public void toggleRenderBox() {
        this.showRenderBox = !this.showRenderBox;
        this.func_70296_d();
    }

    public void toggleOffset(int direction) {
        switch (direction) {
            case 1: {
                if (this.getoffsetY() < -1 - this.getHeightModifierAmount()) break;
                this.offsetY = this.getoffsetY() - 1;
                break;
            }
            case 2: {
                if (this.getoffsetY() > 1 + this.getHeightModifierAmount()) break;
                this.offsetY = this.getoffsetY() + 1;
                break;
            }
            case 3: {
                if (this.getoffsetZ() < -1 - this.getWidthModifierAmount()) break;
                this.offsetZ = this.getoffsetZ() - 1;
                break;
            }
            case 4: {
                if (this.getoffsetZ() > 1 + this.getWidthModifierAmount()) break;
                this.offsetZ = this.getoffsetZ() + 1;
                break;
            }
            case 5: {
                if (this.getoffsetX() < -1 - this.getWidthModifierAmount()) break;
                this.offsetX = this.getoffsetX() - 1;
                break;
            }
            case 6: {
                if (this.getoffsetX() > 1 + this.getWidthModifierAmount()) break;
                this.offsetX = this.getoffsetX() + 1;
            }
        }
        this.func_70296_d();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getProgressScaled(int count) {
        return this.getProgress() * count / this.MAX_SPAWNING_TIME;
    }

    private boolean canOperate() {
        return this.hasSpawnEggItem() && this.hasFuel();
    }

    public boolean hasSpawnEggItem() {
        return !this.inputSlots.getStackInSlot(0).func_190926_b() && this.inputSlots.getStackInSlot(0).func_77973_b() instanceof SpawnEggItem;
    }

    private boolean hasFuel() {
        return !this.fuelSlot.getStackInSlot(0).func_190926_b() && this.fuelSlot.getStackInSlot(0).func_77973_b() == ModItems.SOLID_XP_BABY.get();
    }

    private boolean hasWidthUpgrade() {
        return !this.inputSlots.getStackInSlot(1).func_190926_b() && this.inputSlots.getStackInSlot(1).func_77973_b() == ModItems.SPAWNER_UPGRADE_WIDTH.get();
    }

    public int getWidthModifierAmount() {
        return this.hasWidthUpgrade() ? this.inputSlots.getStackInSlot(1).func_190916_E() : 0;
    }

    private boolean hasHeightUpgrade() {
        return !this.inputSlots.getStackInSlot(2).func_190926_b() && this.inputSlots.getStackInSlot(2).func_77973_b() == ModItems.SPAWNER_UPGRADE_HEIGHT.get();
    }

    public int getHeightModifierAmount() {
        return this.hasHeightUpgrade() ? this.inputSlots.getStackInSlot(2).func_190916_E() : 0;
    }

    private boolean hasSpeedUpgrade() {
        return !this.inputSlots.getStackInSlot(3).func_190926_b() && this.inputSlots.getStackInSlot(3).func_77973_b() == ModItems.XP_SOLIDIFIER_UPGRADE.get();
    }

    public int getSpeedModifierAmount() {
        return this.hasSpeedUpgrade() ? this.inputSlots.getStackInSlot(3).func_190916_E() : 0;
    }

    public AxisAlignedBB getAABBWithModifiers() {
        double x = (double)this.func_174877_v().func_177958_n() + 0.5;
        double y = (double)this.func_174877_v().func_177956_o() + 0.5;
        double z = (double)this.func_174877_v().func_177952_p() + 0.5;
        return new AxisAlignedBB(x - 1.5 - (double)this.getWidthModifierAmount(), y - 0.5 - (double)this.getHeightModifierAmount(), z - 1.5 - (double)this.getWidthModifierAmount(), x + 1.5 + (double)this.getWidthModifierAmount(), y + 0.5 + (double)this.getHeightModifierAmount(), z + 1.5 + (double)this.getWidthModifierAmount()).func_72317_d((double)this.getoffsetX(), (double)this.getoffsetY(), (double)this.getoffsetZ());
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getAABBForRender() {
        return new AxisAlignedBB(-1.0 - (double)this.getWidthModifierAmount(), -0.0 - (double)this.getHeightModifierAmount(), -1.0 - (double)this.getWidthModifierAmount(), 2.0 + (double)this.getWidthModifierAmount(), 1.0 + (double)this.getHeightModifierAmount(), 2.0 + (double)this.getWidthModifierAmount()).func_72317_d((double)this.getoffsetX(), (double)this.getoffsetY(), (double)this.getoffsetZ());
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return this.getAABBWithModifiers();
    }

    public int getoffsetX() {
        return Math.max(-2 - this.getWidthModifierAmount(), Math.min(this.offsetX, 2 + this.getWidthModifierAmount()));
    }

    public int getoffsetY() {
        return Math.max(-1 - this.getHeightModifierAmount(), Math.min(this.offsetY, 1 + this.getHeightModifierAmount()));
    }

    public int getoffsetZ() {
        return Math.max(-2 - this.getWidthModifierAmount(), Math.min(this.offsetZ, 2 + this.getWidthModifierAmount()));
    }

    private void setProgress(int counter) {
        this.spawning_progress = counter;
        this.updateBlock();
    }

    public int getProgress() {
        return this.spawning_progress;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.inputSlots.deserializeNBT(nbt.func_74775_l("inputSlots"));
        this.fuelSlot.deserializeNBT(nbt.func_74775_l("fuelSlot"));
        this.isOn = nbt.func_74767_n("isOn");
        this.showRenderBox = nbt.func_74767_n("showRenderBox");
        this.offsetX = nbt.func_74762_e("offsetX");
        this.offsetY = nbt.func_74762_e("offsetY");
        this.offsetZ = nbt.func_74762_e("offsetZ");
        this.spawning_progress = nbt.func_74762_e("spawning_progress");
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_218657_a("inputSlots", (INBT)this.inputSlots.serializeNBT());
        nbt.func_218657_a("fuelSlot", (INBT)this.fuelSlot.serializeNBT());
        nbt.func_74757_a("isOn", this.isOn);
        nbt.func_74757_a("showRenderBox", this.showRenderBox);
        nbt.func_74768_a("offsetX", this.offsetX);
        nbt.func_74768_a("offsetY", this.offsetY);
        nbt.func_74768_a("offsetZ", this.offsetZ);
        nbt.func_74768_a("spawning_progress", this.spawning_progress);
        return nbt;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        return this.func_189515_b(nbt);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_230337_a_(this.func_195044_w(), packet.func_148857_g());
    }

    public void updateBlock() {
        this.func_145831_w().func_184138_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c), this.func_145831_w().func_180495_p(this.field_174879_c), 3);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent("block.mob_grinding_utils.entity_spawner");
    }

    @Nullable
    public Container createMenu(int windowID, PlayerInventory playerInventory, PlayerEntity player) {
        return new ContainerMGUSpawner(windowID, playerInventory, new PacketBuffer(Unpooled.buffer()).func_179255_a(this.field_174879_c));
    }

    @OnlyIn(value=Dist.CLIENT)
    public Entity getEntityToRender() {
        Entity entity = null;
        if (this.hasSpawnEggItem()) {
            ItemStack eggStack = this.inputSlots.getStackInSlot(0);
            SpawnEggItem eggItem = (SpawnEggItem)eggStack.func_77973_b();
            entity = eggItem.func_208076_b(null).func_200721_a(this.func_145831_w());
        }
        return entity;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.fuelSlotCap.cast();
        }
        return super.getCapability(cap, side);
    }
}

