/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.tile;

import io.netty.buffer.Unpooled;
import java.util.List;
import javax.annotation.Nonnull;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.ModItems;
import mob_grinding_utils.blocks.BlockFan;
import mob_grinding_utils.inventory.server.ContainerFan;
import mob_grinding_utils.items.ItemFanUpgrade;
import mob_grinding_utils.tile.TileEntityInventoryHelper;
import net.minecraft.block.AirBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileEntityFan
extends TileEntityInventoryHelper
implements ITickableTileEntity,
INamedContainerProvider {
    private static final int[] SLOTS = new int[]{0, 1, 2};
    public boolean showRenderBox;
    float xPos;
    float yPos;
    float zPos;
    float xNeg;
    float yNeg;
    float zNeg;

    public TileEntityFan() {
        super(ModBlocks.FAN.getTileEntityType(), 3);
    }

    public void func_73660_a() {
        if (this.func_145831_w().func_82737_E() % 2L == 0L && this.func_145831_w().func_180495_p(this.func_174877_v()).func_177230_c() instanceof BlockFan && ((Boolean)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((Property)BlockFan.POWERED)).booleanValue()) {
            this.activateBlock();
        }
        if (!this.func_145831_w().field_72995_K) {
            this.setAABBWithModifiers();
        }
    }

    public int getWidthModifier() {
        return this.hasWidthUpgrade() ? ((ItemStack)this.getItems().get(0)).func_190916_E() : 0;
    }

    public int getHeightModifier() {
        return this.hasHeightUpgrade() ? ((ItemStack)this.getItems().get(1)).func_190916_E() : 0;
    }

    public int getSpeedModifier() {
        return this.hasSpeedUpgrade() ? ((ItemStack)this.getItems().get(2)).func_190916_E() : 0;
    }

    public void setAABBWithModifiers() {
        BlockState state2;
        int distance;
        BlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        Direction facing = (Direction)state.func_177229_b((Property)BlockFan.field_176387_N);
        for (distance = 1; distance < 5 + this.getSpeedModifier() && ((state2 = this.func_145831_w().func_180495_p(this.func_174877_v().func_177967_a(facing, distance))).func_177230_c() instanceof AirBlock || state2.func_185904_a() == Material.field_151582_l); ++distance) {
        }
        if (facing == Direction.UP) {
            this.yPos = distance;
            this.yNeg = -1.0f;
            this.xPos = this.getHeightModifier();
            this.xNeg = this.getHeightModifier();
            this.zPos = this.getWidthModifier();
            this.zNeg = this.getWidthModifier();
        }
        if (facing == Direction.DOWN) {
            this.yNeg = distance;
            this.yPos = -1.0f;
            this.xPos = this.getHeightModifier();
            this.xNeg = this.getHeightModifier();
            this.zPos = this.getWidthModifier();
            this.zNeg = this.getWidthModifier();
        }
        if (facing == Direction.WEST) {
            this.xNeg = distance;
            this.xPos = -1.0f;
            this.zPos = this.getWidthModifier();
            this.zNeg = this.getWidthModifier();
            this.yPos = this.getHeightModifier();
            this.yNeg = this.getHeightModifier();
        }
        if (facing == Direction.EAST) {
            this.xPos = distance;
            this.xNeg = -1.0f;
            this.zPos = this.getWidthModifier();
            this.zNeg = this.getWidthModifier();
            this.yPos = this.getHeightModifier();
            this.yNeg = this.getHeightModifier();
        }
        if (facing == Direction.NORTH) {
            this.zNeg = distance;
            this.zPos = -1.0f;
            this.xPos = this.getWidthModifier();
            this.xNeg = this.getWidthModifier();
            this.yPos = this.getHeightModifier();
            this.yNeg = this.getHeightModifier();
        }
        if (facing == Direction.SOUTH) {
            this.zPos = distance;
            this.zNeg = -1.0f;
            this.xPos = this.getWidthModifier();
            this.xNeg = this.getWidthModifier();
            this.yPos = this.getHeightModifier();
            this.yNeg = this.getHeightModifier();
        }
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 8);
    }

    public AxisAlignedBB getAABBWithModifiers() {
        return new AxisAlignedBB((double)((float)this.func_174877_v().func_177958_n() - this.xNeg), (double)((float)this.func_174877_v().func_177956_o() - this.yNeg), (double)((float)this.func_174877_v().func_177952_p() - this.zNeg), (double)this.func_174877_v().func_177958_n() + 1.0 + (double)this.xPos, (double)this.func_174877_v().func_177956_o() + 1.0 + (double)this.yPos, (double)this.func_174877_v().func_177952_p() + 1.0 + (double)this.zPos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getAABBForRender() {
        return new AxisAlignedBB((double)(-this.xNeg), (double)(-this.yNeg), (double)(-this.zNeg), 1.0 + (double)this.xPos, 1.0 + (double)this.yPos, 1.0 + (double)this.zPos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)((float)this.func_174877_v().func_177958_n() - this.xNeg), (double)((float)this.func_174877_v().func_177956_o() - this.yNeg), (double)((float)this.func_174877_v().func_177952_p() - this.zNeg), (double)this.func_174877_v().func_177958_n() + 1.0 + (double)this.xPos, (double)this.func_174877_v().func_177956_o() + 1.0 + (double)this.yPos, (double)this.func_174877_v().func_177952_p() + 1.0 + (double)this.zPos);
    }

    public void toggleRenderBox() {
        this.showRenderBox = !this.showRenderBox;
        this.func_70296_d();
    }

    protected void activateBlock() {
        BlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        if (!(state.func_177230_c() instanceof BlockFan)) {
            return;
        }
        Direction facing = (Direction)state.func_177229_b((Property)BlockFan.field_176387_N);
        List list = this.func_145831_w().func_217357_a(LivingEntity.class, this.getAABBWithModifiers());
        for (Entity entity : list) {
            if (entity == null || !(entity instanceof LivingEntity)) continue;
            if (facing != Direction.UP && facing != Direction.DOWN) {
                entity.func_70024_g((double)MathHelper.func_76126_a((float)(facing.func_176734_d().func_185119_l() * 3.141593f / 180.0f)) * 0.5, 0.0, (double)(-MathHelper.func_76134_b((float)(facing.func_176734_d().func_185119_l() * 3.141593f / 180.0f))) * 0.5);
                continue;
            }
            if (facing == Direction.UP) {
                float f = 0.125f;
                Vector3d vec3d = entity.func_213322_ci();
                entity.func_213293_j(vec3d.field_72450_a, (double)f, vec3d.field_72449_c);
                entity.func_70024_g(0.0, 0.25, 0.0);
                entity.field_70143_R = 0.0f;
                continue;
            }
            entity.func_70024_g(0.0, -0.2, 0.0);
        }
    }

    private boolean hasWidthUpgrade() {
        return !((ItemStack)this.getItems().get(0)).func_190926_b() && ((ItemStack)this.getItems().get(0)).func_77973_b() == ModItems.FAN_UPGRADE_WIDTH.get();
    }

    private boolean hasHeightUpgrade() {
        return !((ItemStack)this.getItems().get(1)).func_190926_b() && ((ItemStack)this.getItems().get(1)).func_77973_b() == ModItems.FAN_UPGRADE_HEIGHT.get();
    }

    private boolean hasSpeedUpgrade() {
        return !((ItemStack)this.getItems().get(2)).func_190926_b() && ((ItemStack)this.getItems().get(2)).func_77973_b() == ModItems.FAN_UPGRADE_SPEED.get();
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("showRenderBox", this.showRenderBox);
        nbt.func_74776_a("xPos", this.xPos);
        nbt.func_74776_a("yPos", this.yPos);
        nbt.func_74776_a("zPos", this.zPos);
        nbt.func_74776_a("xNeg", this.xNeg);
        nbt.func_74776_a("yNeg", this.yNeg);
        nbt.func_74776_a("zNeg", this.zNeg);
        return nbt;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.showRenderBox = nbt.func_74767_n("showRenderBox");
        this.xPos = nbt.func_74760_g("xPos");
        this.yPos = nbt.func_74760_g("yPos");
        this.zPos = nbt.func_74760_g("zPos");
        this.xNeg = nbt.func_74760_g("xNeg");
        this.yNeg = nbt.func_74760_g("yNeg");
        this.zNeg = nbt.func_74760_g("zNeg");
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        return this.func_189515_b(nbt);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_230337_a_(this.func_195044_w(), packet.func_148857_g());
        this.onContentsChanged();
    }

    public void onContentsChanged() {
        if (!this.func_145831_w().field_72995_K) {
            BlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.setAABBWithModifiers();
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 8);
            this.func_70296_d();
        }
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return stack.func_77973_b() instanceof ItemFanUpgrade;
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.getItems(), (int)index);
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Nonnull
    public int[] func_180463_a(Direction side) {
        return SLOTS;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return false;
    }

    public Container createMenu(int windowID, PlayerInventory playerInventory, PlayerEntity player) {
        return new ContainerFan(windowID, playerInventory, new PacketBuffer(Unpooled.buffer()).func_179255_a(this.field_174879_c));
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("block.mob_grinding_utils.fan");
    }
}

