/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mob_grinding_utils.MobGrindingUtils;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class SolidifyRecipe
implements IRecipe<IInventory> {
    private final Ingredient mould;
    private final ItemStack result;
    private final int fluidAmount;
    private final ResourceLocation id;
    public static final String NAME = "solidify";

    public SolidifyRecipe(ResourceLocation id, Ingredient mould, ItemStack result, int fluidAmount) {
        this.id = id;
        this.mould = mould;
        this.result = result;
        this.fluidAmount = fluidAmount;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return false;
    }

    public boolean matches(ItemStack input) {
        return this.mould.test(input);
    }

    public int getFluidAmount() {
        return this.fluidAmount;
    }

    public Ingredient getMould() {
        return this.mould;
    }

    @Nonnull
    public ItemStack func_77572_b(IInventory inv) {
        return this.result.func_77946_l();
    }

    public ItemStack getResult() {
        return this.result.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return this.result;
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)MobGrindingUtils.SOLIDIFIER_RECIPE.get();
    }

    @Nonnull
    public IRecipeType<?> func_222127_g() {
        return MobGrindingUtils.SOLIDIFIER_TYPE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<SolidifyRecipe> {
        @Nonnull
        public SolidifyRecipe read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient"));
            ItemStack result = new ItemStack((IItemProvider)JSONUtils.func_188180_i((JsonObject)json.get("result").getAsJsonObject(), (String)"item"));
            int fluidAmount = json.get("fluidAmount").getAsInt();
            return new SolidifyRecipe(recipeId, ingredient, result, fluidAmount);
        }

        public SolidifyRecipe read(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
            Ingredient mould = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack result = buffer.func_150791_c();
            int fluidAmount = buffer.readInt();
            return new SolidifyRecipe(recipeId, mould, result, fluidAmount);
        }

        public void write(@Nonnull PacketBuffer buffer, SolidifyRecipe recipe) {
            recipe.mould.func_199564_a(buffer);
            buffer.func_150788_a(recipe.result);
            buffer.writeInt(recipe.fluidAmount);
        }
    }

    public static class FinishedRecipe
    implements IFinishedRecipe {
        private final Ingredient mould;
        private final ItemStack result;
        private final int fluidAmount;
        private final ResourceLocation id;

        public FinishedRecipe(ResourceLocation id, Ingredient mould, ItemStack result, int fluidAmount) {
            this.mould = mould;
            this.result = result;
            this.fluidAmount = fluidAmount;
            this.id = id;
        }

        public void func_218610_a(JsonObject json) {
            json.add("ingredient", this.mould.func_200304_c());
            json.addProperty("fluidAmount", (Number)this.fluidAmount);
            JsonObject resultJson = new JsonObject();
            resultJson.addProperty("item", this.result.func_77973_b().getRegistryName().toString());
            json.add("result", (JsonElement)resultJson);
        }

        @Nonnull
        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nonnull
        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)MobGrindingUtils.SOLIDIFIER_RECIPE.get();
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

