/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageFlagSync {
    public boolean wither;
    public boolean dragon;

    public MessageFlagSync(boolean witherIn, boolean dragonIn) {
        this.wither = witherIn;
        this.dragon = dragonIn;
    }

    public static void encode(MessageFlagSync message, PacketBuffer buf) {
        buf.writeBoolean(message.wither);
        buf.writeBoolean(message.dragon);
    }

    public static MessageFlagSync decode(PacketBuffer buf) {
        return new MessageFlagSync(buf.readBoolean(), buf.readBoolean());
    }

    public static void handle(MessageFlagSync message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> {
                CompoundNBT nbt = Minecraft.func_71410_x().field_71439_g.getPersistentData();
                nbt.func_74757_a("MGU_WitherMuffle", message.wither);
                nbt.func_74757_a("MGU_DragonMuffle", message.dragon);
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

