/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.client.jei;

import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.recipe.SolidifyRecipe;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;

public class SolidifierCategory
implements IRecipeCategory<SolidifyRecipe> {
    public static final ResourceLocation ID = new ResourceLocation("mob_grinding_utils", "solidifier_jei");
    private final IDrawableStatic background;

    public SolidifierCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(new ResourceLocation("mob_grinding_utils", "textures/gui/solidifier_jei.png"), 0, 0, 91, 26).setTextureSize(91, 26).build();
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends SolidifyRecipe> getRecipeClass() {
        return SolidifyRecipe.class;
    }

    public String getTitle() {
        return "Solidifier Recipe";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setIngredients(SolidifyRecipe recipe, IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.ITEM, Arrays.asList(recipe.getMould().func_193365_a()));
        ingredients.setInputs(VanillaTypes.FLUID, Arrays.asList(new FluidStack((Fluid)ModBlocks.FLUID_XP.get(), recipe.getFluidAmount())));
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout recipeLayout, final SolidifyRecipe recipe, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 4, 4);
        recipeLayout.getItemStacks().set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        recipeLayout.getFluidStacks().init(2, true, 37, 5);
        recipeLayout.getFluidStacks().set(2, (List)ingredients.getInputs(VanillaTypes.FLUID).get(0));
        recipeLayout.getFluidStacks().addTooltipCallback((ITooltipCallback)new ITooltipCallback<FluidStack>(){

            public void onTooltip(int slotIndex, boolean input, FluidStack ingredient, List<ITextComponent> tooltip) {
                tooltip.add((ITextComponent)new StringTextComponent(recipe.getFluidAmount() + " mB"));
                tooltip.add((ITextComponent)new TranslationTextComponent("mob_grinding_utils.jei.any_experience").func_240699_a_(TextFormatting.GRAY));
            }
        });
        recipeLayout.getItemStacks().init(3, false, 69, 4);
        recipeLayout.getItemStacks().set(3, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }
}

