/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.blocks;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockEntityConveyor
extends Block {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final VoxelShape CONVEYOR_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);

    public BlockEntityConveyor(AbstractBlock.Properties properties) {
        super(properties);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return CONVEYOR_AABB;
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197868_b();
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_195992_f().func_176734_d();
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)direction);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (entity.func_225608_bj_()) {
            return;
        }
        if (entity instanceof MobEntity) {
            ((MobEntity)entity).func_110163_bv();
        } else if (entity instanceof ItemEntity) {
            ((ItemEntity)entity).func_174873_u();
        }
        double speed = this.speed();
        int meta = ((Direction)state.func_177229_b((Property)FACING)).func_176745_a() - 2;
        int[] factorX = new int[]{0, 0, -1, 1};
        int[] factorZ = new int[]{-1, 1, 0, 0};
        if (entity.func_226278_cu_() > (double)pos.func_177956_o() + 0.5) {
            Vector3d vec3d = entity.func_213322_ci();
            if (factorX[meta] == 0 && Math.abs((double)pos.func_177958_n() + 0.5 - entity.func_226277_ct_()) < 0.5 && Math.abs((double)pos.func_177958_n() + 0.5 - entity.func_226277_ct_()) > 0.1) {
                entity.func_213293_j(vec3d.field_72450_a + Math.signum((double)pos.func_177958_n() + 0.5 - entity.func_226277_ct_()) * Math.min(speed, Math.abs((double)pos.func_177958_n() + 0.5 - entity.func_226277_ct_())) / 1.2, vec3d.field_72448_b, vec3d.field_72449_c);
            }
            if (factorZ[meta] == 0 && Math.abs((double)pos.func_177952_p() + 0.5 - entity.func_226281_cx_()) < 0.5 && Math.abs((double)pos.func_177952_p() + 0.5 - entity.func_226281_cx_()) > 0.1) {
                entity.func_213293_j(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c + Math.signum((double)pos.func_177952_p() + 0.5 - entity.func_226281_cx_()) * Math.min(speed, Math.abs((double)pos.func_177952_p() + 0.5 - entity.func_226281_cx_())) / 1.2);
            }
            entity.func_213293_j(vec3d.field_72450_a + (double)factorX[meta] * speed, vec3d.field_72448_b, vec3d.field_72449_c + (double)factorZ[meta] * speed);
        }
    }

    protected double speed() {
        return 0.2;
    }
}

