/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils;

import java.awt.Color;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.blocks.BlockDelightfulDirt;
import mob_grinding_utils.blocks.BlockDreadfulDirt;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.BlockItem;
import net.minecraft.util.IItemProvider;

public class ModColourManager {
    private static final Minecraft MINECRAFT = Minecraft.func_71410_x();

    public static void registerColourHandlers() {
        BlockColors blockColors = MINECRAFT.func_184125_al();
        ItemColors itemColors = MINECRAFT.getItemColors();
        ModColourManager.registerBlockColourHandlers(blockColors);
        ModColourManager.registerItemColourHandlers(blockColors, itemColors);
    }

    private static void registerBlockColourHandlers(BlockColors blockColors) {
        IBlockColor dreadfulDirtColour = (state, blockAccess, pos, tintIndex) -> {
            if (blockAccess != null && pos != null) {
                return new Color(153, 50, 153).getRGB() & 0xFFFFFF;
            }
            return new Color(153, 50, 153).getRGB() & 0xFFFFFF;
        };
        IBlockColor delightfulDirtColour = (state, blockAccess, pos, tintIndex) -> {
            if (blockAccess != null && pos != null) {
                return new Color(190, 255, 0).getRGB() & 0xFFFFFF;
            }
            return new Color(190, 255, 0).getRGB() & 0xFFFFFF;
        };
        blockColors.func_186722_a(dreadfulDirtColour, new Block[]{ModBlocks.DREADFUL_DIRT.getBlock()});
        blockColors.func_186722_a(delightfulDirtColour, new Block[]{ModBlocks.DELIGHTFUL_DIRT.getBlock()});
    }

    private static void registerItemColourHandlers(BlockColors blockColors, ItemColors itemColors) {
        IItemColor itemBlockColourHandler = (stack, tintIndex) -> {
            BlockState state = ((BlockItem)stack.func_77973_b()).func_179223_d().func_176223_P();
            if (state.func_177230_c() instanceof BlockDreadfulDirt) {
                return blockColors.func_228054_a_(state, null, null, tintIndex);
            }
            if (state.func_177230_c() instanceof BlockDelightfulDirt) {
                return blockColors.func_228054_a_(state, null, null, tintIndex);
            }
            return -1;
        };
        itemColors.func_199877_a(itemBlockColourHandler, new IItemProvider[]{ModBlocks.DREADFUL_DIRT.getItem()});
        itemColors.func_199877_a(itemBlockColourHandler, new IItemProvider[]{ModBlocks.DELIGHTFUL_DIRT.getItem()});
    }
}

