/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.containers;

import com.direwolf20.mininggadgets.common.containers.ModificationTableContainer;
import com.direwolf20.mininggadgets.common.items.EnergisedItem;
import com.direwolf20.mininggadgets.common.items.MiningGadget;
import com.direwolf20.mininggadgets.common.items.UpgradeCard;
import com.direwolf20.mininggadgets.common.items.gadget.MiningProperties;
import com.direwolf20.mininggadgets.common.items.upgrade.Upgrade;
import com.direwolf20.mininggadgets.common.items.upgrade.UpgradeBatteryLevels;
import com.direwolf20.mininggadgets.common.items.upgrade.UpgradeTools;
import java.util.List;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.energy.CapabilityEnergy;

public class ModificationTableCommands {
    public static boolean insertButton(ModificationTableContainer container, ItemStack upgrade) {
        Slot laserSlot = (Slot)container.field_75151_b.get(0);
        ItemStack laser = laserSlot.func_75211_c();
        if (laser.func_77973_b() instanceof MiningGadget && upgrade.func_77973_b() instanceof UpgradeCard) {
            Upgrade card = ((UpgradeCard)upgrade.func_77973_b()).getUpgrade();
            if (card == Upgrade.EMPTY) {
                return false;
            }
            List<Upgrade> upgrades = UpgradeTools.getUpgrades(laser);
            boolean hasFortune = UpgradeTools.containsUpgradeFromList(upgrades, Upgrade.FORTUNE_1);
            boolean hasSilk = UpgradeTools.containsUpgradeFromList(upgrades, Upgrade.SILK);
            if (card.getBaseName().equals(Upgrade.RANGE_1.getBaseName())) {
                MiningProperties.setBeamRange(laser, UpgradeTools.getMaxBeamRange(card.getTier()));
                MiningProperties.setBeamMaxRange(laser, UpgradeTools.getMaxBeamRange(card.getTier()));
            }
            if (UpgradeTools.containsUpgrade(laser, card)) {
                return false;
            }
            if (hasFortune && card.getBaseName().equals(Upgrade.SILK.getBaseName()) || hasSilk && card.getBaseName().equals(Upgrade.FORTUNE_1.getBaseName())) {
                ((UpgradeCard)upgrade.func_77973_b()).getUpgrade().setEnabled(false);
            }
            MiningGadget.applyUpgrade(laser, (UpgradeCard)upgrade.func_77973_b());
            if (card.getBaseName().equals(Upgrade.BATTERY_1.getBaseName())) {
                UpgradeBatteryLevels.getBatteryByLevel(card.getTier()).ifPresent(power -> laser.getCapability(CapabilityEnergy.ENERGY).ifPresent(e -> ((EnergisedItem)((Object)((Object)e))).updatedMaxEnergy(power.getPower())));
            }
            return true;
        }
        return false;
    }

    public static void extractButton(ModificationTableContainer container, ServerPlayerEntity player, String upgradeName) {
        Slot laserSlot = (Slot)container.field_75151_b.get(0);
        ItemStack laser = laserSlot.func_75211_c();
        if (!(laser.func_77973_b() instanceof MiningGadget)) {
            return;
        }
        if (!UpgradeTools.containsUpgrades(laser)) {
            return;
        }
        UpgradeTools.getUpgrades(laser).forEach(upgrade -> {
            if (!upgrade.getName().equals(upgradeName)) {
                return;
            }
            UpgradeTools.removeUpgrade(laser, upgrade);
            boolean success = player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)upgrade.getCard(), 1));
            if (!success) {
                player.func_71019_a(new ItemStack((IItemProvider)upgrade.getCard(), 1), true);
            }
            if (upgrade == Upgrade.THREE_BY_THREE) {
                MiningProperties.setRange(laser, 1);
            }
            if (upgrade.getBaseName().equals(Upgrade.RANGE_1.getBaseName())) {
                MiningProperties.setBeamRange(laser, 5);
                MiningProperties.setBeamMaxRange(laser, UpgradeTools.getMaxBeamRange(0));
            }
            if (upgrade.getBaseName().equals(Upgrade.BATTERY_1.getBaseName())) {
                laser.getCapability(CapabilityEnergy.ENERGY).ifPresent(e -> ((EnergisedItem)((Object)((Object)e))).updatedMaxEnergy(UpgradeBatteryLevels.BATTERY.getPower()));
            }
        });
    }
}

